/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.common.BWMItems;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fluids.IFluidBlock;

public class EntityDynamite
extends Entity
implements IProjectile {
    private static final float pi = 3.141593f;
    public ItemStack stack;
    private int fuse;

    public EntityDynamite(World world) {
        this(world, 0.0, 0.0, 0.0, new ItemStack(BWMItems.DYNAMITE));
    }

    public EntityDynamite(World world, double xPos, double yPos, double zPos, ItemStack stack) {
        super(world);
        this.setSize(0.25f, 0.4f);
        this.setPosition(xPos, yPos, zPos);
        this.stack = stack;
        this.fuse = 100;
        this.preventEntitySpawning = true;
        this.stack = stack;
        this.isImmuneToFire = true;
    }

    public EntityDynamite(World world, EntityLivingBase owner, ItemStack stack, boolean isLit) {
        this(world);
        this.setLocationAndAngles(owner.posX, owner.posY + (double)owner.getEyeHeight(), owner.posZ, owner.rotationYaw, owner.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        this.posY -= 0.1;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f)) * 0.4f;
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * 3.141593f)) * 0.4f;
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * 3.141593f)) * 0.4f;
        this.stack = stack;
        this.shoot(this.motionX, this.motionY, this.motionZ, 0.75f, 1.0f);
        if (isLit) {
            this.fuse = 100;
        }
    }

    public void onUpdate() {
        IFluidBlock fluid;
        int x = MathHelper.floor((double)this.posX);
        int y = MathHelper.floor((double)this.posY);
        int z = MathHelper.floor((double)this.posZ);
        Block block = this.getEntityWorld().getBlockState(new BlockPos(x, y, z)).getBlock();
        if (block == Blocks.FLOWING_LAVA || block == Blocks.LAVA) {
            this.fuse = 1;
        } else if (block instanceof IFluidBlock && (fluid = (IFluidBlock)block).getFluid().getTemperature() > 1299) {
            this.fuse = 1;
        }
        if (this.fuse > 0) {
            if (!this.getEntityWorld().isRemote && this.fuse % 20 == 0) {
                this.getEntityWorld().playSound(null, new BlockPos(this.posX, this.posY, this.posZ), SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            --this.fuse;
            if (this.fuse == 0) {
                this.setDead();
                if (!this.getEntityWorld().isRemote) {
                    this.explode();
                }
            }
            if (this.getEntityWorld().isRemote) {
                float smokeOffset = 0.25f;
                if (block instanceof BlockLiquid && this.getEntityWorld().getBlockState(new BlockPos(x, y, z)).getMaterial() == Material.WATER || block instanceof IFluidBlock && this.getEntityWorld().getBlockState(new BlockPos(x, y, z)).getMaterial() == Material.WATER) {
                    this.getEntityWorld().spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * (double)smokeOffset, this.posY - this.motionY * (double)smokeOffset, this.posZ - this.motionZ * (double)smokeOffset, this.motionX, this.motionY, this.motionZ, new int[0]);
                } else {
                    this.getEntityWorld().spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX - this.motionX * (double)smokeOffset, this.posY - this.motionY * (double)smokeOffset, this.posZ - this.motionZ * (double)smokeOffset, this.motionX, this.motionY, this.motionZ, new int[0]);
                }
            }
        } else if (block instanceof BlockFire) {
            this.fuse = 100;
            this.getEntityWorld().playSound(null, new BlockPos(this.posX, this.posY, this.posZ), SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        } else if (this.onGround && Math.abs(this.motionX) < 0.01 && Math.abs(this.motionY) < 0.01 && Math.abs(this.motionZ) < 0.01 && !this.getEntityWorld().isRemote) {
            this.convertToItem();
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= 0.04;
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        this.motionX *= 0.98;
        this.motionY *= 0.98;
        this.motionZ *= 0.98;
        if (this.onGround) {
            this.motionX *= 0.7;
            this.motionZ *= 0.7;
            this.motionY *= -0.5;
        }
        this.extinguish();
    }

    public void shoot(double dX, double dY, double dZ, float angle, float f) {
        float sqrt = MathHelper.sqrt((double)(dX * dX + dY * dY + dZ * dZ));
        dX /= (double)sqrt;
        dY /= (double)sqrt;
        dZ /= (double)sqrt;
        dX += this.rand.nextGaussian() * 0.0075 * (double)f;
        dY += this.rand.nextGaussian() * 0.0075 * (double)f;
        dZ += this.rand.nextGaussian() * 0.0075 * (double)f;
        this.motionX = dX *= (double)angle;
        this.motionY = dY *= (double)angle;
        this.motionZ = dZ *= (double)angle;
        float pitch = MathHelper.sqrt((double)(dX * dX + dZ * dZ));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(dX, dZ) * 180.0 / (double)3.141593f);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(dY, pitch) * 180.0 / (double)3.141593f);
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("Fuse")) {
            this.fuse = tag.getInteger("Fuse");
        }
    }

    protected void writeEntityToNBT(NBTTagCompound tag) {
        if (this.fuse > 0) {
            tag.setInteger("Fuse", this.fuse);
        }
    }

    public void explode() {
        float intensity = 1.5f;
        this.getEntityWorld().createExplosion(null, this.posX, this.posY, this.posZ, intensity, true);
        int x = MathHelper.floor((double)this.posX);
        int y = MathHelper.floor((double)this.posY);
        int z = MathHelper.floor((double)this.posZ);
        Block block = this.getEntityWorld().getBlockState(new BlockPos(x, y, z)).getBlock();
        if (block instanceof BlockLiquid && this.getEntityWorld().getBlockState(new BlockPos(x, y, z)).getMaterial() == Material.WATER) {
            this.redneckFishing(x, y, z);
        }
    }

    private void redneckFishing(int x, int y, int z) {
        for (int i = x - 3; i < x + 4; ++i) {
            for (int j = y - 2; j < y + 4; ++j) {
                for (int k = z - 3; k < z + 4; ++k) {
                    if (!this.isWaterBlock(i, j, k) || this.rand.nextInt(20) != 0) continue;
                    this.spawnDeadFish(i, j, k);
                }
            }
        }
    }

    private boolean isWaterBlock(int x, int y, int z) {
        Block block = this.getEntityWorld().getBlockState(new BlockPos(x, y, z)).getBlock();
        return block instanceof BlockLiquid && this.getEntityWorld().getBlockState(new BlockPos(x, y, z)).getMaterial() == Material.WATER;
    }

    private void spawnDeadFish(int x, int y, int z) {
        LootContext.Builder build = new LootContext.Builder((WorldServer)this.getEntityWorld());
        for (ItemStack stack : this.getEntityWorld().getLootTableManager().getLootTableFromLocation(LootTableList.GAMEPLAY_FISHING_FISH).generateLootForPools(this.getEntityWorld().rand, build.build())) {
            EntityItem item = new EntityItem(this.getEntityWorld(), (double)x, (double)y, (double)z, stack.copy());
            this.getEntityWorld().spawnEntity((Entity)item);
        }
    }

    private void convertToItem() {
        InvUtils.ejectStack(this.getEntityWorld(), this.posX, this.posY, this.posZ, this.stack);
        this.setDead();
    }
}

