/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockKiln;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.common.registry.block.recipe.KilnRecipe;
import betterwithmods.util.InvUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileKiln
extends TileBasic {
    private static final String TAG_CAMO = "camo";
    private static final String TAG_CAMO_META = "camoMeta";
    public IBlockState camoState;

    public void kiln(World world, BlockPos pos, Random rand) {
        if (this.getBlockType() instanceof BlockKiln) {
            BlockKiln block = (BlockKiln)this.getBlockType();
            BlockPos kilnPos = pos.down();
            int oldCookTime = block.getCookCounter((IBlockAccess)world, kilnPos);
            int currentTickRate = 20;
            IBlockState state = world.getBlockState(pos);
            KilnRecipe recipe = BWRegistry.KILN.findRecipe(world, pos, state).orElse(null);
            if (recipe != null) {
                int newCookTime = oldCookTime + 1;
                if (newCookTime > 7) {
                    newCookTime = 0;
                    recipe.craftRecipe(world, pos, rand, state);
                    block.setCookCounter(world, kilnPos, 0);
                } else {
                    if (newCookTime > 0) {
                        world.sendBlockBreakProgress(0, pos, newCookTime + 2);
                    }
                    currentTickRate = block.calculateTickRate(world, kilnPos);
                }
                block.setCookCounter(world, kilnPos, newCookTime);
                if (newCookTime == 0) {
                    world.sendBlockBreakProgress(0, pos, -1);
                    block.setCookCounter(world, kilnPos, 0);
                    world.scheduleBlockUpdate(kilnPos, (Block)block, currentTickRate, 5);
                }
            } else if (oldCookTime != 0) {
                world.sendBlockBreakProgress(0, pos, -1);
                block.setCookCounter(world, kilnPos, 0);
                world.scheduleBlockUpdate(kilnPos, (Block)block, currentTickRate, 5);
            } else {
                world.sendBlockBreakProgress(0, pos, -1);
            }
        }
    }

    public void setCamoState(IBlockState camoState) {
        this.camoState = camoState;
        this.markDirty();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.camoState != null) {
            compound.setString(TAG_CAMO, ((ResourceLocation)Block.REGISTRY.getNameForObject((Object)this.camoState.getBlock())).toString());
            compound.setInteger(TAG_CAMO_META, this.camoState.getBlock().getMetaFromState(this.camoState));
        }
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        Block b = Block.getBlockFromName((String)compound.getString(TAG_CAMO));
        if (b != null) {
            this.camoState = b.getStateFromMeta(compound.getInteger(TAG_CAMO_META));
        }
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        this.world.markBlockRangeForRenderUpdate(this.pos, this.pos);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    @Override
    public void onBreak() {
        Block block = this.camoState.getBlock();
        int meta = block.getMetaFromState(this.camoState);
        InvUtils.ejectStackWithOffset(this.world, this.pos, new ItemStack(block, 1, meta));
    }
}

