/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.api.capabilities.SteamCapability;
import betterwithmods.api.tile.ISteamPower;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySteamPipe
extends TileEntity
implements ITickable,
ISteamPower {
    private int heatUnits = 0;
    private int steamPower = 0;
    private boolean update = false;
    private Random rand = new Random();

    public void update() {
        List<EnumFacing> low;
        if (this.update) {
            this.calculateSteamPower(null);
            this.update = false;
        }
        if (!(low = this.findLowestTransfer(false)).isEmpty()) {
            int exits = low.size();
            EnumFacing facing = low.get(this.rand.nextInt(exits));
            TileEntity tile = this.getWorld().getTileEntity(this.pos.offset(facing));
            if (tile == null || tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                // empty if block
            }
        }
    }

    private List<EnumFacing> findLowestTransfer(boolean heat) {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        if (!heat) {
            for (EnumFacing facing : EnumFacing.VALUES) {
                TileEntity tile = this.getWorld().getTileEntity(this.pos.offset(facing));
                if (tile == null) continue;
                if (this.isPipelineExit(tile, facing)) {
                    dirs.add(facing);
                    continue;
                }
                if (!tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing) || !((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).canTransferItem()) continue;
                if (facing == EnumFacing.DOWN) {
                    if (((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getSteamPower(facing.getOpposite()) != 0) continue;
                    dirs.add(facing);
                    continue;
                }
                if (((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getSteamPower(facing.getOpposite()) >= this.steamPower) continue;
                dirs.add(facing);
            }
        } else {
            for (EnumFacing facing : EnumFacing.VALUES) {
                TileEntity tile = this.getWorld().getTileEntity(this.pos.offset(facing));
                if (tile == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing) || facing == EnumFacing.DOWN || ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getSteamPower(facing.getOpposite()) >= this.steamPower) continue;
                dirs.add(facing);
            }
        }
        return dirs;
    }

    @Override
    public void calculateSteamPower(EnumFacing facing) {
        TileEntity tile;
        int currentPower = this.steamPower;
        int highestNeighbor = 0;
        for (EnumFacing side : EnumFacing.VALUES) {
            tile = this.getWorld().getTileEntity(this.pos.offset(side));
            if (side == EnumFacing.UP || tile == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side) || ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, side)).getSteamPower(side.getOpposite()) <= highestNeighbor) continue;
            highestNeighbor = ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, side)).getSteamPower(side.getOpposite());
        }
        currentPower = highestNeighbor > currentPower ? highestNeighbor - 1 : (currentPower > 0 ? --currentPower : 0);
        if (this.steamPower != currentPower) {
            this.steamPower = currentPower;
            for (EnumFacing side : EnumFacing.VALUES) {
                tile = this.getWorld().getTileEntity(this.pos.offset(side));
                if (tile == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side)) continue;
                ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, side)).setSteamUpdate(true);
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.readSteamPower(tag);
    }

    @Override
    public void readSteamPower(NBTTagCompound tag) {
        if (tag.hasKey("Steam")) {
            this.steamPower = tag.getInteger("Steam");
        }
        if (tag.hasKey("Heat")) {
            this.heatUnits = tag.getInteger("Heat");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        this.writeSteamPower(t);
        return t;
    }

    @Override
    public NBTTagCompound writeSteamPower(NBTTagCompound tag) {
        tag.setInteger("Steam", this.steamPower);
        tag.setInteger("Heat", this.heatUnits);
        return tag;
    }

    @Override
    public int getHeatUnits(EnumFacing facing) {
        int transfer = this.findLowestTransfer(true).size();
        if (transfer > 0) {
            return this.heatUnits / transfer;
        }
        return this.heatUnits;
    }

    @Override
    public int getSteamPower(EnumFacing facing) {
        return this.steamPower;
    }

    @Override
    public void calculateHeatUnits() {
        List<EnumFacing> low = this.findLowestTransfer(true);
        this.heatUnits = 0;
        for (EnumFacing facing : EnumFacing.VALUES) {
            TileEntity tile;
            if (low.contains(facing) || (tile = this.getWorld().getTileEntity(this.pos.offset(facing))) == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing)) continue;
            this.heatUnits = ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getHeatUnits(facing.getOpposite());
        }
    }

    @Override
    public void setSteamUpdate(boolean update) {
        if (this.update != update) {
            this.update = update;
        }
    }

    private boolean isPipelineExit(TileEntity tile, EnumFacing facing) {
        return tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) && !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing) && !(tile instanceof TileEntityHopper) && !(tile instanceof TileEntityFilteredHopper);
    }

    @Override
    public boolean canTransferItem() {
        return true;
    }
}

