/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.api.capabilities.SteamCapability;
import betterwithmods.api.tile.ISteamPower;
import betterwithmods.common.fluid.BWFluidRegistry;
import betterwithmods.common.fluid.FluidTankRestricted;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntitySteamBoiler
extends TileEntity
implements ITickable,
ISteamPower {
    private int heatUnits = 0;
    private boolean isActive = false;
    private int heatingProgress = 0;
    private byte update = 0;
    private FluidTankRestricted water = new FluidTankRestricted(new FluidStack(FluidRegistry.WATER, 4000), 4000);
    private FluidTankRestricted steam = new FluidTankRestricted(new FluidStack(BWFluidRegistry.STEAM, 4000), 4000);

    public void update() {
        int transfer;
        FluidStack evaporate;
        if (this.heatUnits > 0 && this.steam.getFluidAmount() < this.steam.getCapacity() && this.water.getFluidAmount() > 0 && (evaporate = this.water.getFluid()) != null && evaporate.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000)) && (transfer = Math.min(this.heatUnits, this.steam.getCapacity() - this.steam.getFluidAmount())) != 0 && this.water.drain(transfer, false) != null) {
            transfer = this.water.drain((int)transfer, (boolean)true).amount;
            this.steam.fill(new FluidStack(BWFluidRegistry.STEAM, transfer), true);
        }
        this.update = (byte)(this.update + 1);
        if (this.update > 19) {
            this.update = 0;
            this.calculateSteamPower(null);
            this.calculateHeatUnits();
        }
    }

    @Override
    public void calculateSteamPower(EnumFacing facing) {
        boolean active;
        boolean bl = active = this.steam.getFluidAmount() > 0;
        if (this.isActive != active) {
            this.isActive = active;
            for (EnumFacing side : EnumFacing.VALUES) {
                TileEntity tile;
                if (side == EnumFacing.DOWN || (tile = this.getWorld().getTileEntity(this.pos.offset(side))) == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side)) continue;
                ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, side)).setSteamUpdate(true);
            }
        }
    }

    @Override
    public int getSteamPower(EnumFacing facing) {
        return this.isActive ? 16 : 0;
    }

    @Override
    public void calculateHeatUnits() {
        BlockPos pos = this.pos.offset(EnumFacing.DOWN);
        int heat = 0;
        BWMHeatRegistry.HeatSource source = BWMHeatRegistry.get(this.world, pos);
        if (source != null) {
            heat = source.getHeat();
        }
        if (heat > 0) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0) continue;
                    BlockPos check = pos.add(x, 0, z);
                    heat += BWMHeatRegistry.getHeat(this.world, pos);
                }
            }
        }
        if (heat != this.heatUnits) {
            this.heatUnits = heat;
        }
    }

    @Override
    public int getHeatUnits(EnumFacing facing) {
        int exits = this.getExits().size();
        if (exits > 0) {
            return this.heatUnits / exits;
        }
        return this.heatUnits;
    }

    private List<EnumFacing> getExits() {
        ArrayList<EnumFacing> exits = new ArrayList<EnumFacing>();
        for (EnumFacing facing : EnumFacing.VALUES) {
            TileEntity tile;
            if (facing == EnumFacing.DOWN || (tile = this.getWorld().getTileEntity(this.pos.offset(facing))) == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing)) continue;
            exits.add(facing);
        }
        return exits;
    }

    public FluidTank getFluidTankFromIndex(int index) {
        if (index == 1) {
            return this.steam;
        }
        return this.water;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.readSteamPower(tag);
    }

    @Override
    public void readSteamPower(NBTTagCompound tag) {
        if (tag.hasKey("Active")) {
            this.isActive = tag.getBoolean("Active");
        }
        if (tag.hasKey("Heat")) {
            this.heatUnits = tag.getInteger("Heat");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        this.writeSteamPower(t);
        return t;
    }

    @Override
    public NBTTagCompound writeSteamPower(NBTTagCompound tag) {
        tag.setBoolean("Active", this.isActive);
        tag.setInteger("Heat", this.heatUnits);
        return tag;
    }

    @Override
    public void setSteamUpdate(boolean update) {
    }

    @Override
    public boolean canTransferItem() {
        return false;
    }
}

