/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.blocks.BlockInfernalEnchanter;
import betterwithmods.common.blocks.tile.TileBasic;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TileEntityInfernalEnchanter
extends TileBasic
implements ITickable {
    private static final int RADIUS = 8;
    public int bookcaseCount;
    private boolean active;

    private static float getPower(World world, BlockPos pos) {
        float power = ForgeHooks.getEnchantPower((World)world, (BlockPos)pos);
        if (power > 0.0f) {
            for (EnumFacing facing : EnumFacing.HORIZONTALS) {
                if (world.getBlockState(pos.offset(facing)).getMaterial().isSolid()) continue;
                return power;
            }
        }
        return 0.0f;
    }

    public void update() {
        if (this.getWorld().getTotalWorldTime() % 20L == 0L) {
            this.bookcaseCount = 0;
            for (int x = -8; x <= 8; ++x) {
                for (int y = -8; y <= 8; ++y) {
                    for (int z = -8; z <= 8; ++z) {
                        BlockPos current = this.pos.add(x, y, z);
                        float power = TileEntityInfernalEnchanter.getPower(this.world, current);
                        if (!(power > 0.0f)) continue;
                        this.bookcaseCount = (int)((float)this.bookcaseCount + power);
                    }
                }
            }
        }
        if (this.getWorld().getTotalWorldTime() % 5L == 0L) {
            boolean players;
            boolean bl = players = !this.world.getEntitiesWithinAABB(EntityPlayer.class, new AxisAlignedBB(this.pos).grow(3.0)).isEmpty();
            if (this.active != players) {
                this.active = players;
                if (this.active) {
                    this.world.playSound(null, this.pos, SoundEvents.ITEM_FIRECHARGE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            IBlockState state = this.world.getBlockState(this.pos);
            if (this.active) {
                this.world.setBlockState(this.pos, state.withProperty((IProperty)BlockInfernalEnchanter.ACTIVE, (Comparable)Boolean.valueOf(true)));
                int x = this.pos.getX();
                int y = this.pos.getY();
                int z = this.pos.getZ();
                this.getWorld().spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.125, (double)y + 0.9, (double)z + 0.125, 0.0, 0.0, 0.0, new int[0]);
                this.getWorld().spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.875, (double)y + 0.9, (double)z + 0.125, 0.0, 0.0, 0.0, new int[0]);
                this.getWorld().spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.875, (double)y + 0.9, (double)z + 0.875, 0.0, 0.0, 0.0, new int[0]);
                this.getWorld().spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.125, (double)y + 0.9, (double)z + 0.875, 0.0, 0.0, 0.0, new int[0]);
            } else {
                this.world.setBlockState(this.pos, state.withProperty((IProperty)BlockInfernalEnchanter.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public int getBookcaseCount() {
        return this.bookcaseCount;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("bookcaseCount", this.bookcaseCount);
        compound.setBoolean("active", this.active);
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.bookcaseCount = compound.getInteger("bookcaseCount");
        this.active = compound.getBoolean("active");
        super.readFromNBT(compound);
    }

    public String getName() {
        return "bwm.infernalenchanter";
    }

    public boolean isActive() {
        return this.active;
    }
}

