/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.ICrankable;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.mechanical.BlockCookingPot;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.util.DirUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityDragonVessel
extends TileBasic
implements ITickable,
IMechanicalPower,
ICrankable {
    private final int MAX_EXPERIENCE = 1395;
    private int experience;
    private int maxDist = 5;
    private EnumFacing facing = EnumFacing.UP;
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    public static final String BWM_PULLER_TAG = "BWMpuller";

    private int addExperience(int xp) {
        if (this.experience >= 1395) {
            return xp;
        }
        if (this.experience < 1395 - xp) {
            this.experience += xp;
            return 0;
        }
        if (this.experience >= 1395 - xp) {
            int newXp = xp - (1395 - this.experience);
            this.experience += newXp;
            return xp - newXp;
        }
        return xp;
    }

    private void hooverXP(EntityXPOrb entity) {
        if (!this.world.isRemote && !entity.isDead) {
            int xpValue = entity.getXpValue();
            int xpDrained = MathHelper.clamp((int)(1395 - this.experience), (int)0, (int)xpValue);
            this.addExperience(xpValue);
            this.markDirty();
            if ((xpValue -= xpDrained) > 0) {
                entity.xpValue = xpValue;
                TileEntityDragonVessel.release((Entity)entity);
            } else {
                entity.setDead();
            }
        }
    }

    public void update() {
        if (this.getBlockWorld().isRemote) {
            return;
        }
        if (this.getBlockWorld().getBlockState(this.pos).getBlock() instanceof BlockCookingPot) {
            IBlockState state = this.getBlockWorld().getBlockState(this.pos);
            if (!this.isPowered()) {
                this.facing = EnumFacing.UP;
                AxisAlignedBB box = new AxisAlignedBB(this.pos).grow((double)this.maxDist);
                List xp = this.world.getEntitiesWithinAABB(EntityXPOrb.class, box);
                for (EntityXPOrb entity : xp) {
                    boolean silent;
                    double zDist;
                    double yDist;
                    double xDist = (double)this.getPos().getX() + 0.5 - entity.posX;
                    double totalDistance = Math.sqrt(xDist * xDist + (yDist = (double)this.getPos().getY() + 0.5 - entity.posY) * yDist + (zDist = (double)this.getPos().getZ() + 0.5 - entity.posZ) * zDist);
                    if (totalDistance < 1.5) {
                        this.hooverXP(entity);
                        continue;
                    }
                    if (!TileEntityDragonVessel.shouldAttract(this.getPos(), (Entity)entity)) continue;
                    double d = 1.0 - Math.max(0.1, totalDistance) / (double)this.maxDist;
                    double speed = 0.01 + d * 0.02;
                    entity.motionX += xDist / totalDistance * speed;
                    entity.motionZ += zDist / totalDistance * speed;
                    entity.motionY += yDist / totalDistance * speed;
                    if (yDist > 0.5) {
                        entity.motionY = 0.12;
                    }
                    entity.setSilent(!(silent = entity.isSilent()));
                    entity.setSilent(silent);
                }
            } else {
                this.facing = this.getPoweredSide();
                this.ejectExperience(DirUtils.rotateFacingAroundY(this.facing, false));
            }
            if (this.facing != state.getValue((IProperty)DirUtils.TILTING)) {
                this.world.setBlockState(this.pos, state.withProperty((IProperty)DirUtils.TILTING, (Comparable)this.facing));
            }
        }
    }

    private void ejectExperience(EnumFacing facing) {
        if (this.experience > 0) {
            boolean ejectIntoWorld;
            BlockPos target = this.pos.offset(facing);
            IBlockState targetState = this.getBlockWorld().getBlockState(target);
            boolean bl = ejectIntoWorld = this.getBlockWorld().isAirBlock(target) || targetState.getBlock().isReplaceable((IBlockAccess)this.getBlockWorld(), target) || !targetState.getMaterial().isSolid() || targetState.getBoundingBox((IBlockAccess)this.getBlockWorld(), (BlockPos)target).maxY < 0.5;
            if (ejectIntoWorld) {
                BlockPos vec = new BlockPos(0, 0, 0).offset(facing);
                int xp = EntityXPOrb.getXPSplit((int)this.experience);
                this.experience -= xp;
                this.markDirty();
                EntityXPOrb orb = new EntityXPOrb(this.world, (double)((float)this.pos.getX() + 0.5f) - (double)vec.getX() / 4.0, (double)this.pos.getY() + 0.25, (double)this.pos.getZ() + 0.5 - (double)vec.getZ() / 4.0, xp);
                orb.motionX = 0.0;
                orb.motionY = 0.0;
                orb.motionZ = 0.0;
                this.world.spawnEntity((Entity)orb);
            }
        }
    }

    public static boolean shouldAttract(@Nullable BlockPos pullerPos, @Nullable Entity entity) {
        if (entity == null || entity.isDead) {
            return false;
        }
        if (entity instanceof IProjectile && entity.motionY > 0.01) {
            return false;
        }
        NBTTagCompound data = entity.getEntityData();
        if (TileEntityDragonVessel.isReservedByOthers(data)) {
            return false;
        }
        if (!TileEntityDragonVessel.isReservedByBWM(data)) {
            if (pullerPos != null) {
                data.setLong(BWM_PULLER_TAG, pullerPos.toLong());
            }
            return true;
        }
        if (pullerPos == null) {
            return false;
        }
        long posL = data.getLong(BWM_PULLER_TAG);
        if (posL == pullerPos.toLong()) {
            return true;
        }
        BlockPos curOwner = BlockPos.fromLong((long)posL);
        double distToCur = curOwner.distanceSqToCenter(entity.posX, entity.posY, entity.posZ);
        double distToMe = pullerPos.distanceSqToCenter(entity.posX, entity.posY, entity.posZ);
        if (distToMe + 1.0 < distToCur) {
            data.setLong(BWM_PULLER_TAG, pullerPos.toLong());
            return true;
        }
        return false;
    }

    public static void release(@Nullable Entity entity) {
        if (entity != null && !entity.isDead) {
            NBTTagCompound data = entity.getEntityData();
            data.removeTag(BWM_PULLER_TAG);
        }
    }

    public static boolean isReserved(Entity entity) {
        return TileEntityDragonVessel.isReservedByBWM(entity.getEntityData()) || TileEntityDragonVessel.isReservedByOthers(entity.getEntityData());
    }

    public static boolean isReservedByBWM(NBTTagCompound data) {
        return data.hasKey(BWM_PULLER_TAG);
    }

    public static boolean isReservedByOthers(NBTTagCompound data) {
        return data.hasKey(PREVENT_REMOTE_MOVEMENT);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.facing = tag.hasKey("facing") ? EnumFacing.getFront((int)tag.getInteger("facing")) : EnumFacing.UP;
        this.experience = tag.hasKey("Experience") ? tag.getInteger("Experience") : 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        t.setInteger("facing", this.facing.getIndex());
        t.setInteger("Experience", this.experience);
        return t;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean isInputtingPower(EnumFacing facing) {
        return this.getMechanicalInput(facing) > 0;
    }

    private EnumFacing getPoweredSide() {
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            if (!this.isInputtingPower(facing)) continue;
            return facing;
        }
        return null;
    }

    private boolean isPowered() {
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            if (!this.isInputtingPower(facing)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.getPos();
    }

    @Override
    public Block getBlock() {
        return this.getBlockType();
    }
}

