/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.blocks.tile.TileBasicInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityBlockDispenser
extends TileBasicInventory {
    public int nextIndex = 0;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("NextSlot")) {
            this.nextIndex = tag.getInteger("NextSlot");
        }
    }

    @Override
    public int getInventorySize() {
        return 16;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        t.setInteger("NextSlot", this.nextIndex);
        return t;
    }

    public void addStackToInventory(ItemStack stack, BlockPos pos) {
        if (stack.isEmpty()) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            ItemStack check = this.inventory.getStackInSlot(i);
            if (check.isEmpty() || !ItemStack.areItemsEqual((ItemStack)stack, (ItemStack)check) || check.getCount() >= check.getMaxStackSize() || (check.hasTagCompound() || stack.hasTagCompound()) && !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)check)) continue;
            check.grow(1);
            this.inventory.setStackInSlot(i, check);
            return;
        }
        int firstSlot = this.findFirstNullStack();
        if (firstSlot > -1) {
            this.inventory.setStackInSlot(firstSlot, stack);
        } else {
            EntityItem item = new EntityItem(this.getWorld(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
            item.setDefaultPickupDelay();
            this.getWorld().spawnEntity((Entity)item);
        }
    }

    private int findFirstNullStack() {
        for (int i = 0; i < 16; ++i) {
            if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public ItemStack getCurrentSlot() {
        return this.inventory.getStackInSlot(this.nextIndex % 16);
    }

    public ItemStack getNextStackFromInv() {
        int slot;
        if (this.nextIndex >= this.inventory.getSlots() || this.inventory.getStackInSlot(this.nextIndex).isEmpty()) {
            slot = this.findNextValidSlot(this.nextIndex);
            if (slot < 0) {
                return ItemStack.EMPTY;
            }
            this.nextIndex = slot;
        }
        ItemStack nextStack = this.inventory.getStackInSlot(this.nextIndex);
        slot = this.findNextValidSlot(this.nextIndex);
        this.nextIndex = slot < 0 ? 0 : slot;
        return nextStack;
    }

    private int findNextValidSlot(int currentSlot) {
        int slot;
        for (slot = currentSlot + 1; slot < this.inventory.getSlots(); ++slot) {
            if (this.inventory.getStackInSlot(slot).isEmpty()) continue;
            return slot;
        }
        for (slot = 0; slot < currentSlot; ++slot) {
            if (this.inventory.getStackInSlot(slot).isEmpty()) continue;
            return slot;
        }
        if (!this.inventory.getStackInSlot(currentSlot).isEmpty()) {
            return currentSlot;
        }
        return -1;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.getWorld().getTileEntity(this.pos) == this && player.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }
}

