/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.module.hardcore.beacons.CapabilityBeacon;
import betterwithmods.module.hardcore.beacons.HCBeacons;
import betterwithmods.module.hardcore.beacons.IBeaconEffect;
import betterwithmods.module.hardcore.beacons.SpawnBeaconEffect;
import betterwithmods.util.ColorUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityBeacon
extends net.minecraft.tileentity.TileEntityBeacon
implements ITickable {
    private int level;
    private int prevLevel;
    private IBlockState type = Blocks.AIR.getDefaultState();
    private IBeaconEffect effect;
    private IBeaconEffect prevEffect;
    private int tick;
    private List<BeamSegment> segments = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;

    public TileEntityBeacon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean canSeeSky() {
        if (this.world.provider.isSurfaceWorld()) {
            return this.world.canBlockSeeSky(this.pos);
        }
        if (this.world.provider.isNether()) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getPos().up());
            while (pos.getY() < 128) {
                IBlockState state = this.world.getBlockState((BlockPos)pos);
                if (state.getBlock() == Blocks.BEDROCK) {
                    return true;
                }
                if (state.getBlock().getLightOpacity(state, (IBlockAccess)this.world, (BlockPos)pos) > 0) {
                    return false;
                }
                pos.setY(pos.getY() + 1);
            }
            return true;
        }
        return false;
    }

    public void update() {
        if (this.tick <= 0) {
            if (!this.canSeeSky()) {
                if (this.level != 0) {
                    this.level = 0;
                    this.prevLevel = 0;
                    this.world.playSound(null, this.pos, SoundEvents.ENTITY_WITHER_DEATH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return;
            }
            Pair<Integer, IBlockState> current = this.calcLevel();
            this.level = (Integer)current.getKey();
            this.type = (IBlockState)current.getValue();
            if (this.level > 0) {
                this.effect = HCBeacons.getBeaconEffect(this.type);
                if (this.level != this.prevLevel) {
                    CapabilityBeacon storage = (CapabilityBeacon)this.world.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
                    if (storage != null) {
                        storage.addBeacon(this.pos, this.level);
                    }
                    this.world.playBroadcastSound(1023, this.getPos(), 0);
                    if (this.effect != null) {
                        this.effect.breakBlock(this.world, this.pos, this.prevLevel);
                    }
                    this.world.getEntitiesWithinAABB(EntityPlayerMP.class, new AxisAlignedBB(this.pos, this.pos.add(1, -4, 1)).grow(10.0, 5.0, 10.0)).forEach(player -> CriteriaTriggers.CONSTRUCT_BEACON.trigger(player, (net.minecraft.tileentity.TileEntityBeacon)this));
                }
                if (this.effect != null) {
                    this.effect.effect(this.world, this.pos, this.level);
                    this.calcSegments();
                }
                this.prevEffect = this.effect;
            } else {
                this.segments.clear();
                this.effect = null;
                CapabilityBeacon storage = (CapabilityBeacon)this.world.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
                if (storage != null) {
                    storage.removeBeacon(this.pos);
                }
            }
            if (this.prevEffect != null && this.effect != this.prevEffect) {
                this.prevEffect.breakBlock(this.world, this.pos, this.prevLevel);
            }
            if (this.level != this.prevLevel) {
                this.prevLevel = this.level;
            }
            this.tick = this.effect != null ? this.effect.getTickSpeed() : 120;
        }
        --this.tick;
    }

    @SideOnly(value=Side.CLIENT)
    public float getBeamScale() {
        int i = (int)(this.world.getTotalWorldTime() - this.beamRenderCounter);
        this.beamRenderCounter = this.world.getTotalWorldTime();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    private void calcSegments() {
        this.segments.clear();
        BeamSegment segment = new BeamSegment(ColorUtils.getColorFromBlock(this.world, this.getPos().up(), this.getPos()));
        this.segments.add(segment);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getPos().up());
        while (pos.getY() < 256) {
            float[] color = ColorUtils.getColorFromBlock(this.world, (BlockPos)pos, this.getPos());
            if (!Arrays.equals(color, new float[]{1.0f, 1.0f, 1.0f})) {
                if (Arrays.equals(color = ColorUtils.average(color, segment.getColors()), segment.getColors())) {
                    segment.incrementHeight();
                } else {
                    segment = new BeamSegment(color);
                    this.segments.add(segment);
                }
            } else {
                segment.incrementHeight();
            }
            pos.move(EnumFacing.UP);
        }
    }

    public List<BeamSegment> getSegments() {
        return this.segments;
    }

    private boolean isSameBlock(IBlockState state, int x, int y, int z) {
        BlockPos pos = this.getPos().add(x, y, z);
        return state == this.world.getBlockState(pos);
    }

    private boolean isValidBlock(IBlockState state) {
        return HCBeacons.BEACON_EFFECTS.containsKey(state) || state.getBlock().isBeaconBase((IBlockAccess)this.world, this.pos.down(), this.pos);
    }

    public Pair<Integer, IBlockState> calcLevel() {
        IBlockState state = this.world.getBlockState(this.pos.down());
        if (this.isValidBlock(state)) {
            int r;
            for (r = 1; r <= 4; ++r) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        if (this.isSameBlock(state, x, -r, z)) continue;
                        return Pair.of((Object)(r - 1), (Object)state);
                    }
                }
            }
            return Pair.of((Object)(r - 1), (Object)state);
        }
        return Pair.of((Object)0, (Object)Blocks.AIR.getDefaultState());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("level", this.level);
        compound.setInteger("prevLevel", this.prevLevel);
        compound.setInteger("tick", this.tick);
        NBTTagCompound tag = new NBTTagCompound();
        NBTUtil.writeBlockState((NBTTagCompound)tag, (IBlockState)this.type);
        compound.setTag("type", (NBTBase)tag);
        if (SpawnBeaconEffect.SPAWN_LIST.containsKey(this.getPos())) {
            NBTTagList list = new NBTTagList();
            for (SpawnBeaconEffect.BindingPoint point : SpawnBeaconEffect.SPAWN_LIST.get(this.getPos())) {
                list.appendTag((NBTBase)point.serializeNBT());
            }
            compound.setTag("spawns", (NBTBase)list);
        }
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.level = compound.getInteger("level");
        this.prevLevel = compound.getInteger("prevLevel");
        this.tick = compound.getInteger("tick");
        NBTTagCompound type = (NBTTagCompound)compound.getTag("type");
        this.type = NBTUtil.readBlockState((NBTTagCompound)type);
        if (compound.hasKey("spawns")) {
            NBTTagList list = compound.getTagList("spawns", 10);
            HashSet points = Sets.newHashSet();
            for (NBTTagCompound tag : list) {
                points.add(new SpawnBeaconEffect.BindingPoint(tag));
            }
            SpawnBeaconEffect.SPAWN_LIST.put(this.getPos(), points);
        }
        super.readFromNBT(compound);
    }

    public boolean processInteraction(World world, EntityPlayer player, ItemStack stack) {
        Block block;
        IBlockState state;
        if (player.isCreative() && !stack.isEmpty() && stack.getItem() instanceof ItemBlock && this.isValidBlock(state = (block = ((ItemBlock)stack.getItem()).getBlock()).getStateFromMeta(stack.getMetadata()))) {
            for (int r = 1; r <= stack.getCount(); ++r) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        this.world.setBlockState(this.getPos().add(x, -r, z), state);
                    }
                }
            }
        }
        if (!world.isRemote && this.effect != null) {
            boolean interacted = this.effect.processInteractions(world, this.getPos(), this.getLevels() - 1, player, stack);
            if (interacted) {
                this.world.playBroadcastSound(1023, this.getPos(), 0);
            }
            return interacted;
        }
        return false;
    }

    public int getLevels() {
        return this.level;
    }

    public boolean isEnabled() {
        return this.level > 0;
    }

    public void onRemoved() {
        this.breakBlock();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        SpawnBeaconEffect.removeAll(this.getPos());
        CapabilityBeacon storage = (CapabilityBeacon)this.world.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
        if (storage != null) {
            storage.removeBeacon(this.pos);
        }
    }

    @SubscribeEvent
    public void findSpawn(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        if (SpawnBeaconEffect.shouldSpawnHere(this.getPos(), (EntityPlayer)player, this.world)) {
            player.setSpawnPoint(this.getPos().up(), true);
        } else {
            player.setSpawnPoint(this.world.getSpawnPoint(), false);
        }
    }

    public void breakBlock() {
        if (this.effect != null) {
            this.effect.breakBlock(this.world, this.pos, this.level);
        }
    }

    public class BeamSegment
    extends TileEntityBeacon.BeamSegment {
        public BeamSegment(float[] colorsIn) {
            super(colorsIn);
        }

        protected void incrementHeight() {
            super.incrementHeight();
        }
    }
}

