/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.module.hardcore.beacons.EnderchestCap;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class TileEnderchest
extends TileEntityEnderChest {
    private Type type = Type.NONE;

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("type", this.type.ordinal());
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound.hasKey("type")) {
            this.type = Type.VALUES[compound.getInteger("type")];
        }
        super.readFromNBT(compound);
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public static enum Type {
        NONE((tile, player) -> ((EnderchestCap)tile.getCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.UP)).getInventory()),
        DIMENSION1((tile, player) -> {
            World world = tile.getWorld();
            if (world.hasCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.SOUTH)) {
                return ((EnderchestCap)world.getCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.SOUTH)).getInventory();
            }
            return null;
        }),
        DIMENSION2((tile, player) -> ((EnderchestCap)tile.getWorld().getCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.NORTH)).getInventory()),
        GLOBAL((tile, player) -> ((EnderchestCap)DimensionManager.getWorld((int)0).getCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.DOWN)).getInventory()),
        PRIVATE((tile, player) -> player.getInventoryEnderChest());

        public static Type[] VALUES;
        private BiFunction<TileEntity, EntityPlayer, InventoryEnderChest> function;

        private Type(BiFunction<TileEntity, EntityPlayer, InventoryEnderChest> function) {
            this.function = function;
        }

        public BiFunction<TileEntity, EntityPlayer, InventoryEnderChest> getFunction() {
            return this.function;
        }

        static {
            VALUES = Type.values();
        }
    }
}

