/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mini;

import betterwithmods.common.blocks.mini.BlockMini;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockSiding
extends BlockMini {
    private static final AxisAlignedBB[] boxes = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5), new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockSiding(Material mat) {
        super(mat);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)TYPE, (Comparable)Integer.valueOf(0)).withProperty((IProperty)this.getOrientationProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockMini.PropertyOrientation getOrientationProperty() {
        return SIDING_ORIENTATION;
    }

    @Override
    public IBlockState getStateForAdvancedRotationPlacement(IBlockState defaultState, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockMini.PropertyOrientation facingProperty = this.getOrientationProperty();
        IBlockState state = defaultState;
        float hitXFromCenter = hitX - 0.5f;
        float hitYFromCenter = hitY - 0.5f;
        float hitZFromCenter = hitZ - 0.5f;
        switch (facing.getAxis()) {
            case Y: {
                if (this.inCenter(hitXFromCenter, hitZFromCenter, 0.25f)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(facing.getOpposite().getIndex()));
                    break;
                }
                if (this.isMax(hitXFromCenter, hitZFromCenter)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf((hitXFromCenter > 0.0f ? EnumFacing.EAST : EnumFacing.WEST).getIndex()));
                    break;
                }
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf((hitZFromCenter > 0.0f ? EnumFacing.SOUTH : EnumFacing.NORTH).getIndex()));
                break;
            }
            case X: {
                if (this.inCenter(hitYFromCenter, hitZFromCenter, 0.25f)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(facing.getOpposite().getIndex()));
                    break;
                }
                if (this.isMax(hitYFromCenter, hitZFromCenter)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf((hitYFromCenter > 0.0f ? EnumFacing.UP : EnumFacing.DOWN).getIndex()));
                    break;
                }
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf((hitZFromCenter > 0.0f ? EnumFacing.SOUTH : EnumFacing.NORTH).getIndex()));
                break;
            }
            case Z: {
                if (this.inCenter(hitYFromCenter, hitXFromCenter, 0.25f)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(facing.getOpposite().getIndex()));
                    break;
                }
                if (this.isMax(hitYFromCenter, hitXFromCenter)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf((hitYFromCenter > 0.0f ? EnumFacing.UP : EnumFacing.DOWN).getIndex()));
                    break;
                }
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf((hitXFromCenter > 0.0f ? EnumFacing.EAST : EnumFacing.WEST).getIndex()));
                break;
            }
            default: {
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(facing.getOpposite().getIndex()));
            }
        }
        return state;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = (Integer)this.getActualState(state, source, pos).getValue((IProperty)this.getOrientationProperty());
        return boxes[i];
    }

    @Override
    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        EnumFacing facing = EnumFacing.getFront((int)((Integer)state.getValue((IProperty)this.getOrientationProperty())));
        return facing == face ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

