/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.mechanical.BlockSaw;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.common.registry.block.recipe.SawRecipe;
import betterwithmods.util.WorldUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileSaw
extends TileBasic
implements IMechanicalPower {
    private int power;

    public void cut(World world, BlockPos pos, Random rand) {
        if (!(this.getBlockType() instanceof BlockSaw)) {
            return;
        }
        EnumFacing facing = this.getBlock().getFacing((IBlockAccess)world, pos);
        BlockPos blockPos = pos.offset(facing);
        IBlockState state = world.getBlockState(blockPos);
        if (world.isAirBlock(blockPos)) {
            return;
        }
        SawRecipe recipe = BWRegistry.WOOD_SAW.findRecipe(world, blockPos, state).orElse(null);
        if (recipe != null && !recipe.craftRecipe(world, blockPos, rand, state) && !this.getBlock().isChoppingBlock(state) && WorldUtils.isSolid(world, blockPos, facing, state)) {
            world.playSound(null, blockPos, BWSounds.METAL_HACKSAW, SoundCategory.BLOCKS, 1.0f, 0.8f);
        }
    }

    public void onChanged() {
        int power = this.calculateInput();
        if (this.power != power) {
            this.power = power;
            this.getBlock().setActive(this.world, this.pos, power > 0);
        }
    }

    @Override
    public boolean overpowerChance() {
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("power", this.power);
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.power = compound.getInteger("power");
        super.readFromNBT(compound);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing != this.getBlock().getFacing((IBlockAccess)this.world, this.pos)) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public BlockSaw getBlock() {
        if (this.getBlockType() instanceof BlockSaw) {
            return (BlockSaw)this.getBlockType();
        }
        throw new IllegalStateException("This TileEntity does not have the correct block, something is severely wrong. Report to the mod author immediately");
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }
}

