/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.ICrankable;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.mechanical.tile.TileCrank;
import betterwithmods.common.blocks.tile.TileBasicInventory;
import betterwithmods.util.DirUtils;
import betterwithmods.util.StackEjector;
import betterwithmods.util.VectorBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityMill
extends TileBasicInventory
implements ITickable,
IMechanicalPower,
ICrankable,
IProgressSource {
    public boolean blocked;
    public int power;
    public int grindCounter = 0;
    public int grindMax;
    private int increment = 1;

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public boolean isActive() {
        return this.power > 0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    @Override
    public BlockMechMachines getBlock() {
        if (this.getBlockType() instanceof BlockMechMachines) {
            return (BlockMechMachines)this.getBlockType();
        }
        throw new IllegalStateException("This TileEntity does not have the correct block, something is severely wrong. Report to the mod author immediately");
    }

    private boolean findIfBlocked() {
        int count = 0;
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            BlockPos offset = this.pos.offset(facing);
            IBlockState state = this.world.getBlockState(offset);
            Material material = state.getMaterial();
            if (!this.world.isSideSolid(offset, facing.getOpposite()) && (material.isReplaceable() || material.isOpaque())) continue;
            ++count;
        }
        return count > 1;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void update() {
        if (this.getBlockWorld().isRemote) {
            return;
        }
        this.power = this.calculateInput();
        this.blocked = this.findIfBlocked();
        this.getBlock().setActive(this.world, this.pos, this.isActive());
        if (this.isBlocked()) {
            return;
        }
        if (this.isActive()) {
            BWRegistry.MILLSTONE.craftRecipe(this.world, this, this.inventory);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("blocked")) {
            this.blocked = tag.getBoolean("blocked");
        }
        if (tag.hasKey("GrindCounter")) {
            this.grindCounter = tag.getInteger("GrindCounter");
        }
        if (tag.hasKey("GrindMax")) {
            this.grindMax = tag.getInteger("GrindMax");
        }
        if (tag.hasKey("increment")) {
            this.increment = tag.getInteger("increment");
        }
        this.power = tag.getInteger("power");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("GrindCounter", this.grindCounter);
        tag.setInteger("GrindMax", this.grindMax);
        tag.setInteger("power", this.power);
        tag.setInteger("increment", this.increment);
        tag.setBoolean("blocked", this.blocked);
        return tag;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    private boolean canEject(EnumFacing facing) {
        if (this.world.isAirBlock(this.pos.offset(facing))) {
            return true;
        }
        return !this.world.isBlockFullCube(this.pos.offset(facing)) && !this.world.isSideSolid(this.pos.offset(facing), facing.getOpposite());
    }

    private void ejectStack(ItemStack stack) {
        List<EnumFacing> validDirections = Lists.newArrayList((Object[])EnumFacing.HORIZONTALS).stream().filter(this::canEject).collect(Collectors.toList());
        if (validDirections.isEmpty()) {
            this.blocked = true;
            return;
        }
        VectorBuilder builder = new VectorBuilder();
        BlockPos offset = this.pos.offset(DirUtils.getRandomFacing(validDirections, this.getBlockWorld().rand));
        new StackEjector(this.world, stack, builder.set((Vec3i)offset).rand(0.5).offset(0.25).build(), builder.setGaussian(0.05f, 0.0, 0.05f).build()).ejectStack();
    }

    public void ejectRecipe(NonNullList<ItemStack> output) {
        if (!output.isEmpty()) {
            for (ItemStack anOutput : output) {
                ItemStack stack = anOutput.copy();
                if (stack.isEmpty()) continue;
                this.ejectStack(stack);
            }
        }
    }

    public boolean isGrinding() {
        return this.grindCounter > 0;
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.getAxis().isVertical()) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
        }
        if (this.world.getTileEntity(this.pos.offset(facing)) instanceof TileCrank) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.getPos();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.getBlockWorld().getTileEntity(this.pos) == this && player.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public int getMax() {
        return this.grindMax;
    }

    @Override
    public int getProgress() {
        return this.grindCounter;
    }
}

