/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.ISoulSensitive;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IHopperFilter;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.client.model.filters.ModelWithResource;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.registry.HopperFilter;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFilteredHopper
extends TileEntityVisibleInventory
implements IMechanicalPower,
IProgressSource {
    private final int STACK_SIZE = 8;
    public SimpleStackHandler filter;
    public IHopperFilter hopperFilter = HopperFilter.NONE;
    public int soulsRetained = 0;
    public byte power;
    private int ejectCounter = 0;
    private int ejectXPCounter = 10;
    private int experienceCount = 0;
    private int maxExperienceCount = 1000;
    private ISoulSensitive prevContainer;

    public TileEntityFilteredHopper() {
        this.occupiedSlots = 0;
        this.hasCapability = facing -> facing == EnumFacing.DOWN || facing == EnumFacing.UP;
        this.filter = new SimpleStackHandler(1, this);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("EjectCounter")) {
            this.ejectCounter = tag.getInteger("EjectCounter");
        }
        if (tag.hasKey("XPCount")) {
            this.experienceCount = tag.getInteger("XPCount");
        }
        if (tag.hasKey("Souls")) {
            this.soulsRetained = tag.getInteger("Souls");
        }
        this.power = tag.getByte("power");
        if (tag.hasKey("Item")) {
            this.filter.setStackInSlot(0, new ItemStack(tag.getCompoundTag("Item")));
        }
        this.validateInventory();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        t.setInteger("EjectCounter", this.ejectCounter);
        t.setInteger("XPCount", this.experienceCount);
        t.setInteger("Souls", this.soulsRetained);
        t.setByte("power", this.power);
        if (!this.filter.getStackInSlot(0).isEmpty()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.filter.getStackInSlot(0).writeToNBT(itemTag);
            t.setTag("Item", (NBTBase)itemTag);
        }
        return t;
    }

    public boolean isPowered() {
        return this.power > 0;
    }

    public boolean isXPFull() {
        return this.experienceCount >= this.maxExperienceCount;
    }

    public void insert(Entity entity) {
        if (!InvUtils.isFull((IItemHandler)this.inventory) && entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            if (item.isDead) {
                return;
            }
            if (HopperInteractions.attemptToCraft(this.hopperFilter.getName(), this.getBlockWorld(), this.getBlockPos(), item, this)) {
                this.getBlockWorld().playSound(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((this.getBlockWorld().rand.nextFloat() - this.getBlockWorld().rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            } else if (this.canFilterProcessItem(item.getItem()) && InvUtils.insertFromWorld((IItemHandler)this.inventory, item, 0, 18, false)) {
                this.getBlockWorld().playSound(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((this.getBlockWorld().rand.nextFloat() - this.getBlockWorld().rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        this.hopperFilter.onInsert(this.world, this.pos, this, entity);
    }

    private void extract() {
        Optional<IItemHandler> inv = InvUtils.getItemHandler(this.world, this.pos.down(), EnumFacing.UP);
        if (this.ejectCounter > 2) {
            int slot = InvUtils.getFirstOccupiedStackInRange((IItemHandler)this.inventory, 0, 17);
            if (slot != -1) {
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (inv.isPresent()) {
                    if (InvUtils.canInsert(inv.get(), stack, 8)) {
                        ItemStack insert = InvUtils.insert(inv.get(), stack, 8, false);
                        InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, stack, 8 - insert.getCount(), false);
                    }
                } else if (this.canDropIntoBlock(this.pos.down())) {
                    InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, stack, 8, false);
                    InvUtils.spawnStack(this.world, (double)this.pos.getX() + 0.5, (double)this.pos.getY() - 0.5, (double)this.pos.getZ() + 0.5, 8, stack);
                }
            }
            this.ejectCounter = 0;
        } else {
            ++this.ejectCounter;
        }
        if (this.ejectXPCounter > 2) {
            if (this.canDropIntoBlock(this.pos.down()) && this.experienceCount > 19) {
                this.experienceCount -= 20;
                this.spawnEntityXPOrb(20);
            }
            this.ejectXPCounter = 0;
        } else {
            ++this.ejectXPCounter;
        }
    }

    private boolean canDropIntoBlock(BlockPos pos) {
        return this.world.getBlockState(pos).getMaterial().isReplaceable();
    }

    public void update() {
        if (!this.world.isRemote) {
            byte power = (byte)this.calculateInput();
            if (this.power != power) {
                this.power = power;
            }
            if (this.getBlock() != null) {
                this.getBlock().setActive(this.world, this.pos, this.isActive());
            }
            if (this.isPowered()) {
                this.extract();
            }
        }
    }

    public boolean isActive() {
        return this.power > 0;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int x = this.pos.getX();
        int y = this.pos.getY();
        int z = this.pos.getZ();
        return this.getBlockWorld().getTileEntity(this.pos) == this && player.getDistanceSq((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 64.0;
    }

    @Override
    public void markDirty() {
        super.markDirty();
        if (this.getBlockWorld() != null) {
            this.validateInventory();
        }
    }

    private boolean validateInventory() {
        byte slotsOccupied;
        boolean stateChanged = false;
        ItemStack filter = this.getFilterStack();
        IHopperFilter newFilter = BWRegistry.HOPPER_FILTERS.getFilter(filter);
        if (this.hopperFilter != newFilter) {
            this.hopperFilter = newFilter;
            stateChanged = true;
        }
        if ((slotsOccupied = (byte)InvUtils.getOccupiedStacks((IItemHandler)this.inventory, 0, 17)) != this.occupiedSlots) {
            this.occupiedSlots = slotsOccupied;
            stateChanged = true;
        }
        if (this.getBlockWorld() != null && stateChanged) {
            IBlockState state = this.getBlockWorld().getBlockState(this.pos);
            this.getBlockWorld().notifyBlockUpdate(this.pos, state, state, 3);
        }
        return stateChanged;
    }

    public IHopperFilter getHopperFilter() {
        return this.hopperFilter;
    }

    private boolean canFilterProcessItem(ItemStack stack) {
        this.validateInventory();
        return this.hopperFilter.allow(stack);
    }

    private void spawnEntityXPOrb(int value) {
        double xOff = this.getBlockWorld().rand.nextDouble() * 0.1 + 0.45;
        double yOff = -0.5;
        double zOff = this.getBlockWorld().rand.nextDouble() * 0.1 + 0.45;
        EntityXPOrb orb = new EntityXPOrb(this.getBlockWorld(), (double)this.pos.getX() + xOff, (double)this.pos.getY() + yOff, (double)this.pos.getZ() + zOff, value);
        orb.motionX = 0.0;
        orb.motionY = 0.0;
        orb.motionZ = 0.0;
        this.getBlockWorld().spawnEntity((Entity)orb);
    }

    @Nullable
    public ISoulSensitive getSoulContainer() {
        Block block = this.world.getBlockState(this.pos.down()).getBlock();
        if (block instanceof ISoulSensitive && ((ISoulSensitive)block).isSoulSensitive((IBlockAccess)this.world, this.pos.down())) {
            return (ISoulSensitive)block;
        }
        return null;
    }

    public void decreaseSoulCount(int numSouls) {
        this.soulsRetained = Math.max(this.soulsRetained - numSouls, 0);
        this.markDirty();
    }

    public void increaseSoulCount(int numSouls) {
        this.soulsRetained += numSouls;
        ISoulSensitive container = this.getSoulContainer();
        if (container != null) {
            if (this.prevContainer != container) {
                this.soulsRetained = numSouls;
            }
            int soulsConsumed = container.processSouls(this.getBlockWorld(), this.pos.down(), this.soulsRetained);
            if (container.consumeSouls(this.getBlockWorld(), this.pos.down(), soulsConsumed)) {
                this.soulsRetained -= soulsConsumed;
            }
        } else if (this.soulsRetained > 7 && !this.isPowered()) {
            if (WorldUtils.spawnGhast(this.world, this.pos)) {
                this.getBlockWorld().playSound(null, this.pos, SoundEvents.ENTITY_GHAST_SCREAM, SoundCategory.BLOCKS, 1.0f, this.getBlockWorld().rand.nextFloat() * 0.1f + 0.8f);
            }
            this.overpower();
        }
        this.prevContainer = container;
        this.markDirty();
    }

    @Override
    public int getInventorySize() {
        return 18;
    }

    @Override
    public SimpleStackHandler createItemStackHandler() {
        return new HopperHandler(this.getInventorySize(), this);
    }

    @Override
    public String getName() {
        return "inv.filtered_hopper.name";
    }

    @Override
    public int getMaxVisibleSlots() {
        return 18;
    }

    public ModelWithResource getModel() {
        return RenderUtils.getModelFromStack(this.getFilterStack());
    }

    public ItemStack getFilterStack() {
        return this.filter.getStackInSlot(0);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.getAxis().isHorizontal()) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }

    @Override
    public BlockMechMachines getBlock() {
        if (this.getBlockType() instanceof BlockMechMachines) {
            return (BlockMechMachines)this.getBlockType();
        }
        return null;
    }

    @Override
    public void onBreak() {
        super.onBreak();
        InvUtils.ejectInventoryContents(this.world, this.pos, (IItemHandler)this.filter);
    }

    public int getExperienceCount() {
        return this.experienceCount;
    }

    public void setExperienceCount(int experienceCount) {
        this.experienceCount = experienceCount;
    }

    public int getMaxExperienceCount() {
        return this.maxExperienceCount;
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int getProgress() {
        return Math.min(this.power, 1);
    }

    private class HopperHandler
    extends SimpleStackHandler {
        TileEntityFilteredHopper hopper;

        public HopperHandler(int size, TileEntityFilteredHopper hopper) {
            super(size, hopper);
            this.hopper = hopper;
        }

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityFilteredHopper.this.world.markBlockRangeForRenderUpdate(TileEntityFilteredHopper.this.pos, TileEntityFilteredHopper.this.pos);
            TileEntityFilteredHopper.this.getBlockWorld().notifyBlockUpdate(TileEntityFilteredHopper.this.pos, TileEntityFilteredHopper.this.world.getBlockState(TileEntityFilteredHopper.this.pos), TileEntityFilteredHopper.this.world.getBlockState(TileEntityFilteredHopper.this.pos), 2);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.hopper.canFilterProcessItem(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return slot == 18 ? 1 : super.getSlotLimit(slot);
        }
    }
}

