/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.ICrankable;
import betterwithmods.api.tile.IHeated;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.common.blocks.mechanical.BlockCookingPot;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.registry.bulk.manager.CraftingManagerBulk;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityCookingPot
extends TileEntityVisibleInventory
implements IMechanicalPower,
IHeated,
ICrankable,
IProgressSource {
    private static final int MAX_TIME = 1000;
    public int cookProgress;
    public int cookTime;
    public EnumFacing facing;
    public int heat;
    protected CraftingManagerBulk<CookingPotRecipe> manager;
    private HashMap<BlockPos, BWMHeatRegistry.HeatSource> heatCache = new HashMap();

    public TileEntityCookingPot(CraftingManagerBulk<CookingPotRecipe> manager) {
        this.manager = manager;
        this.cookProgress = 0;
        this.cookTime = 0;
        this.occupiedSlots = 0;
        this.facing = EnumFacing.UP;
        this.hasCapability = f -> f == this.facing;
    }

    public boolean hasFastRenderer() {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    private boolean isInputtingPower(EnumFacing facing) {
        return this.getMechanicalInput(facing) > 0;
    }

    private EnumFacing getPoweredSide() {
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            if (!this.isInputtingPower(facing)) continue;
            return facing;
        }
        return EnumFacing.UP;
    }

    private boolean isPowered() {
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            if (!this.isInputtingPower(facing)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getInventorySize() {
        return 27;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.facing = EnumFacing.getFront((int)this.value(tag, "facing", EnumFacing.UP.getIndex()));
        this.cookProgress = this.value(tag, "progress", 0);
        this.cookTime = this.value(tag, "time", 4000);
        this.heat = this.value(tag, "heat", 0);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        t.setInteger("facing", this.facing.getIndex());
        t.setInteger("progress", this.cookProgress);
        t.setInteger("heat", this.heat);
        t.setInteger("time", this.cookTime);
        return t;
    }

    public void update() {
        if (this.getBlock() instanceof BlockCookingPot) {
            IBlockState state = this.getBlockWorld().getBlockState(this.pos);
            if (this.isPowered()) {
                this.cookProgress = 0;
                this.facing = this.getPoweredSide();
                this.ejectInventory(DirUtils.rotateFacingAroundY(this.facing, false));
            } else {
                if (this.facing != EnumFacing.UP) {
                    this.facing = EnumFacing.UP;
                }
                this.spawnParticles();
                this.entityCollision();
                if (!this.world.isRemote && !InvUtils.isEmpty((IItemHandler)this.inventory)) {
                    int time;
                    int heat = this.findHeat(this.getPos());
                    if (this.heat != heat) {
                        this.heat = heat;
                        this.cookProgress = 0;
                    }
                    if (this.cookTime != (time = this.findCookTime())) {
                        this.cookTime = time;
                    }
                    this.manager.craftRecipe(this.world, this, this.inventory);
                }
            }
            if (this.facing != state.getValue((IProperty)DirUtils.TILTING)) {
                this.world.setBlockState(this.pos, state.withProperty((IProperty)DirUtils.TILTING, (Comparable)this.facing));
            }
        }
    }

    private int findCookTime() {
        int divisor = -this.heat;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                divisor += this.findHeat(this.pos.add(x, 0, z));
            }
        }
        if (divisor != 0) {
            return 1000 / divisor;
        }
        return 1000;
    }

    @Override
    public int getHeat(World world, BlockPos pos) {
        return this.heat;
    }

    private int findHeat(BlockPos pos) {
        return this.getHeatCached(pos.down());
    }

    private int getHeatCached(BlockPos pos) {
        BWMHeatRegistry.HeatSource src = this.heatCache.get(pos);
        if (src != null && src.matches(this.world, pos)) {
            return src.getHeat();
        }
        if (src != null) {
            this.heatCache.remove(pos);
        }
        if ((src = BWMHeatRegistry.get(this.world, pos)) != null) {
            this.heatCache.put(pos, src);
            return src.getHeat();
        }
        return 0;
    }

    private void spawnParticles() {
        Random random = this.getBlockWorld().rand;
        if (this.heat >= 2 && random.nextDouble() < 0.2) {
            double xOffset = 0.25 + random.nextDouble() * 0.5;
            double zOffset = 0.25 + random.nextDouble() * 0.5;
            this.getBlockWorld().spawnParticle(EnumParticleTypes.CLOUD, (double)this.pos.getX() + xOffset, (double)((float)this.pos.getY() + 0.75f), (double)this.pos.getZ() + zOffset, 0.0, 0.05 + random.nextDouble() * 0.05, 0.0, new int[0]);
        }
    }

    private void entityCollision() {
        if (this.captureDroppedItems()) {
            this.getBlockWorld().scheduleBlockUpdate(this.pos, this.getBlockType(), this.getBlockType().tickRate(this.getBlockWorld()), 5);
            this.markDirty();
        }
    }

    public List<EntityItem> getCaptureItems(World worldIn, BlockPos pos) {
        return worldIn.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.5, (double)pos.getZ() + 1.0), EntitySelectors.IS_ALIVE);
    }

    private boolean captureDroppedItems() {
        boolean insert = false;
        if (!InvUtils.isFull((IItemHandler)this.inventory)) {
            List<EntityItem> items = this.getCaptureItems(this.getBlockWorld(), this.getPos());
            for (EntityItem item : items) {
                insert |= InvUtils.insertFromWorld((IItemHandler)this.inventory, item, 0, 27, false);
            }
        }
        if (insert) {
            this.getBlockWorld().playSound(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((this.getBlockWorld().rand.nextFloat() - this.getBlockWorld().rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return true;
        }
        return false;
    }

    public void ejectInventory(EnumFacing facing) {
        int index = InvUtils.getFirstOccupiedStackNotOfItem((IItemHandler)this.inventory, Items.BRICK);
        if (index >= 0 && index < this.inventory.getSlots()) {
            boolean ejectIntoWorld;
            ItemStack stack = this.inventory.getStackInSlot(index);
            int ejectStackSize = 8;
            if (8 > stack.getCount()) {
                ejectStackSize = stack.getCount();
            }
            BlockPos target = this.pos.offset(facing);
            ItemStack eject = new ItemStack(stack.getItem(), ejectStackSize, stack.getItemDamage());
            InvUtils.copyTags(eject, stack);
            IBlockState targetState = this.getBlockWorld().getBlockState(target);
            boolean bl = ejectIntoWorld = this.getBlockWorld().isAirBlock(target) || targetState.getBlock().isReplaceable((IBlockAccess)this.getBlockWorld(), target) || !targetState.getMaterial().isSolid() || targetState.getBoundingBox((IBlockAccess)this.getBlockWorld(), (BlockPos)target).maxY < 0.5;
            if (ejectIntoWorld) {
                this.getBlockWorld().playSound(null, this.pos, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.BLOCKS, 0.2f, ((this.getBlockWorld().rand.nextFloat() - this.getBlockWorld().rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.ejectStack(this.getBlockWorld(), target, facing, eject);
                this.inventory.extractItem(index, ejectStackSize, false);
            }
        }
    }

    public void ejectStack(World world, BlockPos pos, EnumFacing facing, ItemStack stack) {
        if (world.isRemote) {
            return;
        }
        BlockPos vec = new BlockPos(0, 0, 0).offset(facing);
        EntityItem item = new EntityItem(world, (double)((float)pos.getX() + 0.5f) - (double)vec.getX() / 4.0, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5 - (double)vec.getZ() / 4.0, stack);
        float velocity = 0.05f;
        item.motionX = (float)vec.getX() * velocity;
        item.motionY = (double)((float)vec.getY() * velocity) * 0.1;
        item.motionZ = (float)vec.getZ() * velocity;
        item.setDefaultPickupDelay();
        world.spawnEntity((Entity)item);
    }

    @Override
    public void markDirty() {
        super.markDirty();
        if (this.getBlockWorld() != null) {
            IBlockState state = this.getBlockWorld().getBlockState(this.pos);
            this.getBlockWorld().notifyBlockUpdate(this.pos, state, state, 3);
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.getBlockWorld().getTileEntity(this.pos) == this && player.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public int getMaxVisibleSlots() {
        return 27;
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.getPos();
    }

    @Override
    public Block getBlock() {
        return this.getBlockType();
    }

    @Override
    public int getProgress() {
        return this.cookProgress;
    }

    @Override
    public int getMax() {
        return this.cookTime;
    }
}

