/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.BlockBellows;
import betterwithmods.common.blocks.tile.TileBasic;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileBellows
extends TileBasic
implements IMechanicalPower {
    private int tick;
    private boolean continuous = false;
    private int power;

    public void onChange() {
        if (this.getBlock().getTier(this.world, this.pos) == EnumTier.STEEL) {
            this.continuous = true;
        }
        int power = this.calculateInput();
        if (this.continuous) {
            if (power != this.power) {
                this.power = power;
            }
            if (this.power > 0) {
                if (this.tick >= 37) {
                    this.getBlock().setActive(this.world, this.pos, !this.getBlock().isActive(this.world.getBlockState(this.pos)));
                    this.tick = 0;
                }
                ++this.tick;
            }
        } else if (power != this.power) {
            this.power = power;
            this.getBlock().setActive(this.world, this.pos, this.power > 0);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("power", this.power);
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.power = compound.getInteger("power");
        super.readFromNBT(compound);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing != EnumFacing.UP && facing != this.getBlock().getFacing(this.world.getBlockState(this.pos))) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        if (this.getBlock().getTier(this.world, this.pos) == EnumTier.STEEL) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public BlockBellows getBlock() {
        if (this.getBlockType() instanceof BlockBellows) {
            return (BlockBellows)this.getBlockType();
        }
        throw new IllegalStateException("This TileEntity does not have the correct block, something is severely wrong. Report to the mod author immediately");
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }
}

