/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.IOverpower;
import betterwithmods.api.capabilities.CapabilityAxle;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IAxleTick;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockAxle;
import betterwithmods.common.blocks.mechanical.tile.TileGearbox;
import betterwithmods.common.blocks.tile.TileBasic;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileAxle
extends TileBasic
implements IAxle,
ITickable {
    private byte maxSignal;
    private int maxPower;
    private int minPower;
    private byte signal;
    private int power;
    public static List<IAxleTick> tickHandlers = Lists.newArrayList();

    public TileAxle() {
    }

    public TileAxle(int maxPower, int minPower, byte maxSignal) {
        this.maxPower = maxPower;
        this.minPower = minPower;
        this.maxSignal = maxSignal;
    }

    public void onChanged() {
        byte findSignal = 0;
        int findPower = 0;
        int sources = 0;
        for (EnumFacing facing : this.getDirections()) {
            int power;
            byte next;
            BlockPos offset = this.pos.offset(facing);
            IMechanicalPower mech = BWMAPI.IMPLEMENTATION.getMechanicalPower(this.world, offset, facing);
            if (mech == null) continue;
            IAxle axle = BWMAPI.IMPLEMENTATION.getAxle((IBlockAccess)this.world, offset, facing);
            if (axle != null && this.isFacing(axle) && (next = axle.getSignal()) > findSignal) {
                findSignal = next;
            }
            if ((power = mech.getMechanicalOutput(facing.getOpposite())) <= 0) continue;
            if (power > findPower) {
                ++sources;
                if (axle != null) {
                    if (axle.getSignal() >= findSignal) {
                        findPower = power;
                    }
                } else {
                    findPower = power;
                    if (this.getBlock() == BWMBlocks.STEEL_AXLE && mech.getClass() == TileGearbox.class) {
                        findPower = Math.max(1, findPower / 2);
                    }
                }
            }
            if (axle != null) continue;
            findSignal = this.getMaximumSignal();
        }
        this.setPower(findPower);
        if (sources >= 2) {
            ((IOverpower)this.getBlockType()).overpower(this.world, this.pos);
            return;
        }
        byte newSignal = 0;
        if (findSignal > this.signal) {
            if (findSignal == 1) {
                ((IOverpower)this.getBlockType()).overpower(this.world, this.pos);
            }
            if (this.power > 0) {
                newSignal = (byte)(findSignal - 1);
            }
        } else {
            newSignal = 0;
            this.setPower(0);
        }
        if (newSignal != this.signal) {
            this.setSignal(newSignal);
        }
        this.markDirty();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setByte("signal", this.signal);
        compound.setInteger("power", this.power);
        compound.setByte("maxSignal", this.maxSignal);
        compound.setInteger("maxPower", this.maxPower);
        compound.setInteger("minPower", this.minPower);
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.signal = compound.getByte("signal");
        this.maxSignal = compound.getByte("maxSignal");
        this.power = compound.getInteger("power");
        this.maxPower = compound.getInteger("maxPower");
        this.minPower = compound.getInteger("minPower");
        super.readFromNBT(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityMechanicalPower.MECHANICAL_POWER || capability == CapabilityAxle.AXLE;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        if (capability == CapabilityAxle.AXLE) {
            return (T)CapabilityAxle.AXLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing.getAxis() == this.getAxis()) {
            IAxle axle = BWMAPI.IMPLEMENTATION.getAxle((IBlockAccess)this.world, this.pos.offset(facing), facing);
            if (axle != null && axle.getSignal() > this.getSignal()) {
                return 0;
            }
            return this.power;
        }
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return this.maxPower;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return this.getMaximumInput();
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public byte getSignal() {
        return this.signal;
    }

    @Override
    public byte getMaximumSignal() {
        return this.maxSignal;
    }

    @Override
    public int getMaximumInput() {
        return this.maxPower;
    }

    @Override
    public int getMinimumInput() {
        return this.minPower;
    }

    @Override
    public EnumFacing[] getDirections() {
        return ((BlockAxle)this.getBlockType()).getAxisDirections(this.world.getBlockState(this.pos));
    }

    @Override
    public EnumFacing.Axis getAxis() {
        return ((BlockAxle)this.getBlockType()).getAxis(this.world.getBlockState(this.pos));
    }

    public void setSignal(byte signal) {
        this.signal = signal;
    }

    public void setPower(int power) {
        this.power = Math.min(power, this.maxPower + 1);
    }

    public void markDirty() {
        super.markDirty();
        ((BlockAxle)this.getBlockType()).setActive(this.world, this.pos, this.getPower() > 0);
        for (EnumFacing facing : this.getDirections()) {
            if (BWMAPI.IMPLEMENTATION.isAxle((IBlockAccess)this.world, this.pos.offset(facing), facing.getOpposite())) continue;
            this.world.neighborChanged(this.pos.offset(facing), this.getBlockType(), this.pos);
        }
    }

    public int getPower() {
        return this.power;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.signal, this.power, this.pos);
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }

    @Override
    public Block getBlock() {
        return this.getBlockType();
    }

    public void update() {
        if (!tickHandlers.isEmpty()) {
            tickHandlers.forEach(t -> t.tick(this.world, this.pos, this));
        }
    }
}

