/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IBlockActive {
    public static final PropertyBool ACTIVE = PropertyBool.create((String)"active");

    default public boolean isActive(IBlockState state) {
        if (state.getBlock() instanceof IBlockActive) {
            return (Boolean)state.getValue((IProperty)ACTIVE);
        }
        return false;
    }

    default public void setActive(World world, BlockPos pos, boolean active) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof IBlockActive) {
            if ((Boolean)state.getValue((IProperty)ACTIVE) != active) {
                this.onChangeActive(world, pos, active);
            }
            world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)));
            world.scheduleUpdate(pos, state.getBlock(), 1);
        }
    }

    default public void onChangeActive(World world, BlockPos pos, boolean newValue) {
    }
}

