/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.IOverpower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import betterwithmods.common.blocks.mechanical.tile.TileEntityMill;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import betterwithmods.common.blocks.mechanical.tile.TileEntityTurntable;
import betterwithmods.util.InvUtils;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockMechMachines
extends BWMBlock
implements IBlockActive,
IMultiVariants,
IOverpower {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.create((String)"type", EnumType.class);
    public static final ResourceLocation MILLSTONE = LootTableList.register((ResourceLocation)new ResourceLocation("betterwithmods", "block/mill"));
    public static final ResourceLocation PULLEY = LootTableList.register((ResourceLocation)new ResourceLocation("betterwithmods", "block/pulley"));
    public static final ResourceLocation HOPPER = LootTableList.register((ResourceLocation)new ResourceLocation("betterwithmods", "block/hopper"));
    public static final ResourceLocation TURNTABLE = LootTableList.register((ResourceLocation)new ResourceLocation("betterwithmods", "block/turntable"));

    public BlockMechMachines() {
        super(Material.ROCK);
        this.setTickRandomly(true);
        this.setHardness(3.5f);
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPE, (Comparable)((Object)EnumType.MILL)).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.useNeighborBrightness = true;
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.SINGLE_MACHINES, 1, type.getMeta());
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case HOPPER: {
                return new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 0.99, 1.0);
            }
        }
        return super.getBoundingBox(state, source, pos);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"active=false,type=mill", "active=false,type=pulley", "active=false,type=hopper", "active=false,type=turntable", "active=true,type=mill", "active=true,type=pulley", "active=true,type=hopper", "active=true,type=turntable"};
    }

    public Material getMaterial(IBlockState state) {
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case HOPPER: 
            case PULLEY: {
                this.setHarvestLevel("axe", 0, state);
                return Material.WOOD;
            }
        }
        this.setHarvestLevel("pickaxe", 0, state);
        return super.getMaterial(state);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case HOPPER: 
            case PULLEY: {
                return SoundType.WOOD;
            }
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (state.getBlock() == this) {
            EnumType type = (EnumType)((Object)state.getValue(TYPE));
            return type == EnumType.MILL || type == EnumType.PULLEY || type == EnumType.TURNTABLE;
        }
        return false;
    }

    public int tickRateForMeta(EnumType type) {
        if (type == EnumType.MILL) {
            return 1;
        }
        return 10;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.getValue(TYPE) == EnumType.TURNTABLE && side != null && side.getAxis().isHorizontal();
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        EnumType type = (EnumType)((Object)world.getBlockState(pos).getValue(TYPE));
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRateForMeta(type), 5);
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int damageDropped(IBlockState state) {
        EnumType type = (EnumType)((Object)state.getValue(TYPE));
        return type.getMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getSolidity();
    }

    public boolean isFullCube(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getSolidity();
    }

    public boolean isFullBlock(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getSolidity();
    }

    public boolean causesSuffocation(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getSolidity();
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        boolean isInventory = Arrays.stream(EnumFacing.VALUES).anyMatch(f -> world.getTileEntity(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f));
        if (!player.isSneaking() && world.getTileEntity(pos) != null && isInventory) {
            player.openGui((Object)BWMod.instance, 0, world, pos.getX(), pos.getY(), pos.getZ());
        } else if (world.getTileEntity(pos) != null && world.getTileEntity(pos) instanceof TileEntityTurntable && hand == EnumHand.MAIN_HAND) {
            return ((TileEntityTurntable)world.getTileEntity(pos)).processRightClick(player);
        }
        return true;
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
            return InvUtils.calculateComparatorLevel((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP));
        }
        return 0;
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.getTileEntity(pos) instanceof TileEntityTurntable && !world.getGameRules().getBoolean("doDaylightCycle")) {
            ((TileEntityTurntable)world.getTileEntity(pos)).toggleAsynchronous(null);
        }
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EnumType type = (EnumType)((Object)state.getValue(TYPE));
        if (type == EnumType.HOPPER) {
            TileEntity tile;
            if (!worldIn.isRemote && (tile = worldIn.getTileEntity(pos)) instanceof TileEntityFilteredHopper) {
                TileEntityFilteredHopper hopper = (TileEntityFilteredHopper)tile;
                hopper.insert(entityIn);
            }
            if (entityIn instanceof EntityItem) {
                entityIn.setPosition(entityIn.posX, entityIn.posY + 0.1, entityIn.posZ);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case MILL: {
                return new TileEntityMill();
            }
            case PULLEY: {
                return new TileEntityPulley();
            }
            case HOPPER: {
                return new TileEntityFilteredHopper();
            }
            case TURNTABLE: {
                return new TileEntityTurntable();
            }
        }
        return null;
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.META_LOOKUP) {
            items.add((Object)BlockMechMachines.getStack(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state.getValue(TYPE) == EnumType.MILL && this.isActive(state)) {
            this.emitSmoke(world, pos, rand, 5);
        }
    }

    private void emitSmoke(World world, BlockPos pos, Random rand, int heat) {
        for (int i = 0; i < heat; ++i) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            float fX = (float)x + rand.nextFloat();
            float fY = (float)y + rand.nextFloat() * 0.5f + 1.0f;
            float fZ = (float)z + rand.nextFloat();
            world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, (double)fX, (double)fY, (double)fZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, TYPE});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta))).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta > 3));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta() + ((Boolean)state.getValue((IProperty)ACTIVE) != false ? 4 : 0);
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        this.overpowerSound(world, pos);
        this.breakBlock(world, pos, state);
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case MILL: {
                InvUtils.ejectBrokenItems(world, pos.offset(EnumFacing.random((Random)world.rand)), MILLSTONE);
                world.setBlockToAir(pos);
                break;
            }
            case PULLEY: {
                InvUtils.ejectBrokenItems(world, pos.offset(EnumFacing.random((Random)world.rand)), PULLEY);
                world.setBlockToAir(pos);
                break;
            }
            case HOPPER: {
                InvUtils.ejectBrokenItems(world, pos.offset(EnumFacing.random((Random)world.rand)), HOPPER);
                world.setBlockToAir(pos);
                break;
            }
            case TURNTABLE: {
                InvUtils.ejectBrokenItems(world, pos.offset(EnumFacing.random((Random)world.rand)), TURNTABLE);
                world.setBlockToAir(pos);
            }
        }
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case HOPPER: {
                return face == EnumFacing.UP ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
            }
        }
        return BlockFaceShape.SOLID;
    }

    public static enum EnumType implements IStringSerializable
    {
        MILL(0, "mill", true),
        PULLEY(1, "pulley", true),
        HOPPER(2, "hopper"),
        TURNTABLE(3, "turntable", true);

        private static final EnumType[] META_LOOKUP;
        private int meta;
        private String name;
        private boolean solidity;

        private EnumType(int meta, String name) {
            this(meta, name, false);
        }

        private EnumType(int meta, String name, boolean solid) {
            this.meta = meta;
            this.name = name;
            this.solidity = solid;
        }

        public static EnumType byMeta(int meta) {
            return META_LOOKUP[meta % META_LOOKUP.length];
        }

        public String getName() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean getSolidity() {
            return this.solidity;
        }

        static {
            META_LOOKUP = EnumType.values();
        }
    }
}

