/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.IAdvancedRotationPlacement;
import betterwithmods.api.block.IOverpower;
import betterwithmods.api.block.IRenderRotationPlacement;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileGearbox;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGearbox
extends BlockRotate
implements IBlockActive,
IOverpower,
IAdvancedRotationPlacement,
IRenderRotationPlacement {
    private final int maxPower;
    private EnumTier type;

    public BlockGearbox(int maxPower, EnumTier type) {
        super(Material.WOOD);
        this.maxPower = maxPower;
        this.setHardness(2.0f);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.format((String)"tooltip.gearbox.name", (Object[])new Object[0]));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getStateForAdvancedRotationPlacement(this.getDefaultState(), placer.isSneaking() ? side : side.getOpposite(), flX, flY, flZ);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.setBlockState(pos, state.cycleProperty((IProperty)DirUtils.FACING).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        world.scheduleBlockUpdate(pos, (Block)this, 5, 5);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        this.onChange(world, pos);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        this.onChange(world, pos);
    }

    public void onChange(World world, BlockPos pos) {
        if (!world.isRemote) {
            this.withTile(world, pos).ifPresent(TileGearbox::onChanged);
        }
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacingFromState(world.getBlockState(pos));
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
    }

    private void emitGearboxParticles(World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 5; ++i) {
            float flX = (float)pos.getX() + rand.nextFloat();
            float flY = (float)pos.getY() + rand.nextFloat() * 0.5f + 1.0f;
            float flZ = (float)pos.getZ() + rand.nextFloat();
            world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue()) {
            TileGearbox tile;
            this.emitGearboxParticles(world, pos, rand);
            if (rand.nextInt(10) == 0 && (tile = this.getTile(world, pos)) != null && tile.isOverpowered()) {
                world.playSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_ZOMBIE_ATTACK_DOOR_WOOD, SoundCategory.BLOCKS, 0.25f, world.rand.nextFloat() * 0.25f + 0.25f, true);
            }
            if (rand.nextInt(50) == 0) {
                world.playSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.25f, world.rand.nextFloat() * 0.25f + 0.25f, false);
            }
        }
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean[] dirs = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.getFront((int)i);
            dirs[i] = BWMAPI.IMPLEMENTATION.isAxle(world, pos.offset(facing), facing.getOpposite()) && this.getFacing(world, pos) != facing;
        }
        return state.withProperty((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(dirs[0])).withProperty((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(dirs[1])).withProperty((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(dirs[2])).withProperty((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(dirs[3])).withProperty((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(dirs[4])).withProperty((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(dirs[5]));
    }

    public int getMetaFromState(IBlockState state) {
        int facing = ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex();
        int active = this.isActive(state) ? 1 : 0;
        return active | facing << 1;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1)).withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)(meta >> 1)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, ACTIVE, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState state, World worldIn, BlockPos pos) {
        return this.isActive(state) ? 15 : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileGearbox(this.maxPower);
    }

    public Optional<TileGearbox> withTile(World world, BlockPos pos) {
        return Optional.of(this.getTile(world, pos));
    }

    public TileGearbox getTile(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileGearbox) {
            return (TileGearbox)tile;
        }
        return null;
    }

    @Override
    public void onChangeActive(World world, BlockPos pos, boolean newValue) {
        if (newValue) {
            world.playSound(null, pos, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5f, world.rand.nextFloat() * 0.25f + 0.25f);
        }
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        this.overpowerSound(world, pos);
        EnumFacing facing = (EnumFacing)world.getBlockState(pos).getValue((IProperty)DirUtils.FACING);
        Block block = this.type == EnumTier.WOOD ? BWMBlocks.WOODEN_BROKEN_GEARBOX : BWMBlocks.STEEL_BROKEN_GEARBOX;
        world.setBlockState(pos, block.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)facing));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.type == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float getBlockHardness(IBlockState state, World worldIn, BlockPos pos) {
        if (this.type == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (this.type == EnumTier.STEEL) {
            return SoundType.METAL;
        }
        return SoundType.WOOD;
    }

    public Material getMaterial(IBlockState state) {
        if (this.type == EnumTier.STEEL) {
            return Material.IRON;
        }
        return Material.WOOD;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        EnumFacing facing = this.getFacingFromState(state);
        if (facing.getAxis().isHorizontal()) {
            return state.withProperty((IProperty)DirUtils.FACING, (Comparable)rot.rotate(facing));
        }
        return state;
    }

    @Override
    public IBlockState getStateForAdvancedRotationPlacement(IBlockState defaultState, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = defaultState;
        float hitXFromCenter = hitX - 0.5f;
        float hitYFromCenter = hitY - 0.5f;
        float hitZFromCenter = hitZ - 0.5f;
        EnumFacing newFacing = facing;
        switch (facing.getAxis()) {
            case Y: {
                if (this.inCenter(hitXFromCenter, hitZFromCenter, 0.0625f)) {
                    newFacing = facing.getOpposite();
                    break;
                }
                if (this.isMax(hitXFromCenter, hitZFromCenter)) {
                    newFacing = hitXFromCenter > 0.0f ? EnumFacing.EAST : EnumFacing.WEST;
                    break;
                }
                newFacing = hitZFromCenter > 0.0f ? EnumFacing.SOUTH : EnumFacing.NORTH;
                break;
            }
            case X: {
                if (this.inCenter(hitYFromCenter, hitZFromCenter, 0.0625f)) {
                    newFacing = facing;
                    break;
                }
                if (this.isMax(hitYFromCenter, hitZFromCenter)) {
                    newFacing = hitYFromCenter > 0.0f ? EnumFacing.UP : EnumFacing.DOWN;
                    break;
                }
                newFacing = hitZFromCenter > 0.0f ? EnumFacing.SOUTH : EnumFacing.NORTH;
                break;
            }
            case Z: {
                newFacing = this.inCenter(hitYFromCenter, hitXFromCenter, 0.0625f) ? facing : (this.isMax(hitYFromCenter, hitXFromCenter) ? (hitYFromCenter > 0.0f ? EnumFacing.UP : EnumFacing.DOWN) : (hitXFromCenter > 0.0f ? EnumFacing.EAST : EnumFacing.WEST));
            }
        }
        return state.withProperty((IProperty)DirUtils.FACING, (Comparable)newFacing);
    }

    @Override
    public IBlockState getRenderState(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, ItemStack stack, EntityLivingBase placer) {
        return this.getStateForAdvancedRotationPlacement(this.getDefaultState(), facing, flX, flY, flZ);
    }

    @Override
    public IRenderRotationPlacement.RenderFunction getRenderFunction() {
        return ClientEventHandler::renderBasicGrid;
    }
}

