/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.common.blocks.mechanical.BlockGearbox;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGearBoostedRail
extends BlockRailPowered {
    public static final double MOTION_CART = 0.05;
    public static final double MOTION_SCALE = 0.06;

    public BlockGearBoostedRail() {
        this.setHardness(0.7f);
        this.setSoundType(SoundType.METAL);
    }

    protected void updateState(IBlockState state, World world, BlockPos pos, Block block) {
        boolean isOnPoweredGearbox;
        boolean poweredProperty = (Boolean)state.getValue((IProperty)POWERED);
        if (poweredProperty != (isOnPoweredGearbox = this.isOnActiveGearbox(state, world, pos))) {
            world.setBlockState(pos, state.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(isOnPoweredGearbox)), 3);
            world.notifyNeighborsOfStateChange(pos.down(), (Block)this, false);
            if (((BlockRailBase.EnumRailDirection)state.getValue((IProperty)SHAPE)).isAscending()) {
                world.notifyNeighborsOfStateChange(pos.up(), (Block)this, false);
            }
        }
    }

    private boolean isOnActiveGearbox(IBlockState state, World world, BlockPos pos) {
        if (!(world.getBlockState(pos.down()).getBlock() instanceof BlockGearbox)) {
            return false;
        }
        BlockRailBase.EnumRailDirection dir = (BlockRailBase.EnumRailDirection)state.getValue((IProperty)SHAPE);
        IBlockState below = world.getBlockState(pos.down());
        EnumFacing face = (EnumFacing)below.getValue((IProperty)DirUtils.FACING);
        boolean correctFace = false;
        if (dir == BlockRailBase.EnumRailDirection.ASCENDING_EAST || dir == BlockRailBase.EnumRailDirection.ASCENDING_WEST || dir == BlockRailBase.EnumRailDirection.EAST_WEST) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.NORTH || face == EnumFacing.SOUTH;
        } else if (dir == BlockRailBase.EnumRailDirection.ASCENDING_NORTH || dir == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH || dir == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.EAST || face == EnumFacing.WEST;
        }
        return correctFace && ((BlockGearbox)below.getBlock()).isActive(below);
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    private void accelerateMinecart(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        double planarMotion = Math.sqrt(cart.motionX * cart.motionX + cart.motionZ * cart.motionZ);
        EnumFacing gearboxFace = (EnumFacing)world.getBlockState(pos.down()).getValue((IProperty)DirUtils.FACING);
        switch ((BlockRailBase.EnumRailDirection)state.getValue((IProperty)SHAPE)) {
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: 
            case NORTH_SOUTH: {
                if (planarMotion > 0.01) {
                    if (gearboxFace == EnumFacing.EAST && cart.motionZ < 0.0 || gearboxFace == EnumFacing.WEST && cart.motionZ > 0.0) {
                        cart.motionZ -= cart.motionZ / planarMotion * 0.06;
                        if (world.isRemote || !(planarMotion > 0.05) || !(world.rand.nextDouble() < planarMotion)) break;
                        world.playSound(null, pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 1.0f, 2.0f);
                        break;
                    }
                    cart.motionZ += cart.motionZ / planarMotion * 0.06;
                    break;
                }
                if (gearboxFace == EnumFacing.EAST && !world.getBlockState(pos.west()).isOpaqueCube()) {
                    cart.motionZ = 0.05;
                    break;
                }
                if (gearboxFace == EnumFacing.WEST && !world.getBlockState(pos.east()).isOpaqueCube()) {
                    cart.motionZ = -0.05;
                    break;
                }
                if (gearboxFace == EnumFacing.DOWN && world.getBlockState(pos.west()).isOpaqueCube()) {
                    cart.motionZ = 0.05;
                    break;
                }
                if (gearboxFace != EnumFacing.DOWN || !world.getBlockState(pos.east()).isOpaqueCube()) break;
                cart.motionZ = -0.05;
                break;
            }
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case EAST_WEST: {
                if (planarMotion > 0.01) {
                    if (gearboxFace == EnumFacing.SOUTH && cart.motionX > 0.0 || gearboxFace == EnumFacing.NORTH && cart.motionX < 0.0) {
                        cart.motionX -= cart.motionX / planarMotion * 0.06;
                        if (world.isRemote || !(planarMotion > 0.05) || !(world.rand.nextDouble() < planarMotion)) break;
                        world.playSound(null, pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 1.0f, 2.0f);
                        break;
                    }
                    cart.motionX += cart.motionX / planarMotion * 0.06;
                    break;
                }
                if (gearboxFace == EnumFacing.SOUTH && !world.getBlockState(pos.west()).isOpaqueCube()) {
                    cart.motionX = -0.05;
                    break;
                }
                if (gearboxFace == EnumFacing.NORTH && !world.getBlockState(pos.east()).isOpaqueCube()) {
                    cart.motionX = 0.05;
                    break;
                }
                if (gearboxFace == EnumFacing.DOWN && world.getBlockState(pos.west()).isOpaqueCube()) {
                    cart.motionX = 0.05;
                    break;
                }
                if (gearboxFace != EnumFacing.DOWN || !world.getBlockState(pos.east()).isOpaqueCube()) break;
                cart.motionX = -0.05;
                break;
            }
        }
    }

    private void decelerateMinecart(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        double planarMotion = Math.sqrt(cart.motionX * cart.motionX + cart.motionZ * cart.motionZ);
        if (planarMotion > 0.01) {
            double zMotion = Math.sqrt(cart.motionZ * cart.motionZ);
            double xMotion = Math.sqrt(cart.motionX * cart.motionX);
            if (xMotion > 0.0) {
                cart.motionX -= cart.motionX / planarMotion * 0.06;
            } else if (zMotion > 0.0) {
                cart.motionZ -= cart.motionZ / planarMotion * 0.06;
            }
            this.playBoosterSound(world, pos, planarMotion);
        } else if (state.getValue((IProperty)SHAPE) == BlockRailBase.EnumRailDirection.EAST_WEST || state.getValue((IProperty)SHAPE) == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            cart.motionX = 0.0;
            cart.motionZ = 0.0;
        }
    }

    private void playBoosterSound(World world, BlockPos pos, double planarMotion) {
        if (!world.isRemote && planarMotion > 0.05 && world.rand.nextDouble() < planarMotion) {
            world.playSound(null, pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 1.0f, 2.0f);
        }
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() != this) {
            return;
        }
        IBlockState under = world.getBlockState(pos.down());
        Block blockUnder = under.getBlock();
        if (blockUnder instanceof BlockGearbox) {
            BlockGearbox gearbox = (BlockGearbox)blockUnder;
            EnumFacing face = (EnumFacing)world.getBlockState(pos.down()).getValue((IProperty)DirUtils.FACING);
            if (face == EnumFacing.UP) {
                return;
            }
            if (world.isBlockPowered(pos.down())) {
                return;
            }
            if (gearbox.isActive(under)) {
                this.accelerateMinecart(world, cart, pos);
            } else {
                this.decelerateMinecart(world, cart, pos);
            }
        } else {
            double planarMotion = Math.sqrt(cart.motionX * cart.motionX + cart.motionZ * cart.motionZ);
            this.playBoosterSound(world, pos, planarMotion);
        }
    }
}

