/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.util.DirUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockAxleGenerator
extends BWMBlock
implements IBlockActive {
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);

    public BlockAxleGenerator(Material material) {
        super(material);
        this.setSoundType(SoundType.WOOD);
        this.setHardness(2.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty(DirUtils.AXIS, (Comparable)EnumFacing.Axis.Z).withProperty(EnumTier.TIER, (Comparable)((Object)EnumTier.WOOD)).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.AXIS, EnumTier.TIER, ACTIVE});
    }

    public int getMetaFromState(IBlockState state) {
        int axis = ((EnumFacing.Axis)state.getValue(DirUtils.AXIS)).ordinal();
        int tier = ((EnumTier)((Object)state.getValue(EnumTier.TIER))).ordinal();
        int active = (Boolean)state.getValue((IProperty)ACTIVE) != false ? 1 : 0;
        return axis | tier << 2 | active << 3;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(DirUtils.AXIS, (Comparable)DirUtils.getAxis(meta & 3)).withProperty(EnumTier.TIER, (Comparable)((Object)EnumTier.VALUES[meta >> 2 & 1])).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta >> 3 == 1));
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.getValue(DirUtils.AXIS)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
        }
        return Z_AABB;
    }

    public int tickRate(World world) {
        return 20;
    }

    public abstract ItemStack getItem(World var1, BlockPos var2, IBlockState var3);

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (state.getValue(EnumTier.TIER) == EnumTier.WOOD) {
            drops.add((Object)new ItemStack(BWMBlocks.WOODEN_AXLE));
        } else {
            drops.add((Object)new ItemStack(BWMBlocks.STEEL_AXLE));
        }
        drops.add((Object)this.getItem((World)world, pos, state));
    }

    public IBlockState getAxisState(EnumFacing.Axis axis) {
        return this.getDefaultState().withProperty(DirUtils.AXIS, (Comparable)axis);
    }

    public EnumFacing.Axis getAxis(IBlockState state) {
        return (EnumFacing.Axis)state.getValue(DirUtils.AXIS);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (world.getBlockState(pos).getValue(EnumTier.TIER) == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float getBlockHardness(IBlockState state, World worldIn, BlockPos pos) {
        if (worldIn.getBlockState(pos).getValue(EnumTier.TIER) == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (world.getBlockState(pos).getValue(EnumTier.TIER) == EnumTier.STEEL) {
            return SoundType.METAL;
        }
        return SoundType.WOOD;
    }

    public Material getMaterial(IBlockState state) {
        if (state.getValue(EnumTier.TIER) == EnumTier.STEEL) {
            return Material.IRON;
        }
        return Material.WOOD;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAxis(state) == EnumFacing.Axis.Y;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.getAxis() == this.getAxis(state) ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }
}

