/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.behaviors;

import betterwithmods.BWMod;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.DirUtils;
import betterwithmods.util.player.Profiles;
import com.mojang.authlib.GameProfile;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BehaviorDefaultDispenseBlock
extends BehaviorDefaultDispenseItem {
    protected ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
        EnumFacing facing = (EnumFacing)source.getBlockState().getValue((IProperty)BlockBDispenser.FACING);
        IPosition pos = BlockBDispenser.getDispensePosition((IBlockSource)source);
        BlockPos check = new BlockPos(pos.getX(), pos.getY(), pos.getZ());
        World world = source.getWorld();
        FakePlayer fake = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)Profiles.BWMDISP);
        fake.setHeldItem(EnumHand.MAIN_HAND, stack);
        DirUtils.setEntityOrientationFacing((EntityLivingBase)fake, facing.getOpposite());
        if (GlobalConfig.debug) {
            BWMod.logger.debug("Better With Mods FakePlayer ID: " + fake.getUniqueID());
        }
        if (!world.isAirBlock(check) && !world.getBlockState(check).getBlock().isReplaceable((IBlockAccess)world, check)) {
            return ItemStack.EMPTY;
        }
        if (stack.getItem() instanceof ItemBlock) {
            ItemBlock itemblock = (ItemBlock)stack.getItem();
            if (itemblock.canPlaceBlockOnSide(world, check, facing, (EntityPlayer)fake, stack)) {
                Block block = ((ItemBlock)stack.getItem()).getBlock();
                boolean blockAcross = !world.isAirBlock(check.offset(facing));
                IBlockState state = block.getStateForPlacement(world, check, facing, this.getX(facing, blockAcross), this.getY(facing, blockAcross), this.getZ(facing, blockAcross), stack.getItemDamage(), (EntityLivingBase)fake, fake.getActiveHand());
                if (block.canPlaceBlockAt(world, check) && itemblock.placeBlockAt(stack, (EntityPlayer)fake, world, check, facing, this.getX(facing, blockAcross), this.getY(facing, blockAcross), this.getZ(facing, blockAcross), state)) {
                    world.playSound(null, check, state.getBlock().getSoundType(state, world, check, (Entity)fake).getPlaceSound(), SoundCategory.BLOCKS, 0.7f, 1.0f);
                    stack.shrink(1);
                    return stack.isEmpty() ? ItemStack.EMPTY : stack;
                }
            }
        } else if (stack.getItem() instanceof ItemBlockSpecial) {
            if (stack.getItem().onItemUse((EntityPlayer)fake, world, check, EnumHand.MAIN_HAND, facing, 0.1f, 0.0f, 0.1f) == EnumActionResult.SUCCESS) {
                stack.shrink(1);
                return stack.isEmpty() ? ItemStack.EMPTY : stack;
            }
        } else if (stack.getItem() instanceof ItemSeeds && stack.getItem().onItemUse((EntityPlayer)fake, world, check.down(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.1f, 0.0f, 0.1f) == EnumActionResult.SUCCESS) {
            stack.shrink(1);
            return stack.isEmpty() ? ItemStack.EMPTY : stack;
        }
        return ItemStack.EMPTY;
    }

    private float getX(EnumFacing facing, boolean blockAcross) {
        return facing == EnumFacing.NORTH && blockAcross ? 0.9f : 0.1f;
    }

    private float getY(EnumFacing facing, boolean blockAcross) {
        return facing == EnumFacing.UP && blockAcross ? 0.9f : 0.1f;
    }

    private float getZ(EnumFacing facing, boolean blockAcross) {
        return facing == EnumFacing.WEST && blockAcross ? 0.9f : 0.1f;
    }
}

