/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.common.blocks.ItemBlockMeta;
import betterwithmods.common.entity.EntityUrn;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemBlockUrn
extends ItemBlockMeta {
    public ItemBlockUrn(Block block) {
        super(block);
    }

    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.getHeldItem(handIn);
        if (itemstack.getMetadata() != BlockUrn.EnumType.FULL.getMeta()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (!playerIn.capabilities.isCreativeMode) {
            itemstack.shrink(1);
        }
        worldIn.playSound(null, playerIn.posX, playerIn.posY - 0.5, playerIn.posZ, SoundEvents.ENTITY_SNOWBALL_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isRemote) {
            EntityUrn entity = new EntityUrn(worldIn, (EntityLivingBase)playerIn);
            entity.shoot((Entity)playerIn, playerIn.rotationPitch, playerIn.rotationYaw, 0.0f, 1.5f, 1.0f);
            worldIn.spawnEntity((Entity)entity);
        }
        playerIn.addStat(StatList.getObjectUseStats((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }
}

