/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWolf
extends BWMBlock {
    private ResourceLocation entityName;

    public BlockWolf(ResourceLocation entityName) {
        super(Material.CLOTH);
        this.entityName = entityName;
        this.setHardness(2.0f);
        this.setSoundType(SoundType.CLOTH);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.NORTH));
        this.registerBehavior();
    }

    private void registerBehavior() {
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.putObject((Object)this.entityName, (world, pos, entity, stack) -> {
            if (((EntityAgeable)entity).isChild()) {
                return NonNullList.create();
            }
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.STRING, 1 + world.rand.nextInt(3)));
            world.playSound(null, pos, SoundEvents.ENTITY_WOLF_HURT, SoundCategory.NEUTRAL, 0.75f, 1.0f);
            entity.setDead();
            return InvUtils.asNonnullList(new ItemStack((Block)this));
        });
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.isRemote) {
            for (int i = 0; i < 15; ++i) {
                world.spawnParticle(EnumParticleTypes.HEART, (double)((float)pos.getX() + world.rand.nextFloat()), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + world.rand.nextFloat()), 0.0, (double)0.1f, 0.0, new int[0]);
            }
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.getHeldItemMainhand().isEmpty() && player.getHeldItemOffhand().isEmpty()) {
            if (world.isRemote) {
                world.spawnParticle(EnumParticleTypes.HEART, (double)((float)pos.getX() + world.rand.nextFloat()), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + world.rand.nextFloat()), 0.0, (double)0.1f, 0.0, new int[0]);
            }
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, placer, hand);
        return state.withProperty((IProperty)DirUtils.FACING, (Comparable)DirUtils.convertEntityOrientationToFacing(placer, side));
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(200) == 0) {
            if (rand.nextBoolean()) {
                world.playSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_WOLF_AMBIENT, SoundCategory.BLOCKS, 0.7f, 1.0f, false);
            } else {
                world.playSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_WOLF_PANT, SoundCategory.BLOCKS, 0.7f, 1.0f, false);
            }
        }
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).ordinal();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)meta));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING});
    }
}

