/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.ISoulSensitive;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.util.InvUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockUrn
extends BWMBlock
implements ISoulSensitive,
IMultiVariants {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.create((String)"urntype", EnumType.class);
    public static final PropertyBool UNDERHOPPER = PropertyBool.create((String)"underhopper");
    private static final double OFFSET = 0.375;
    private static final AxisAlignedBB URN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875);
    private static final AxisAlignedBB UNDER_HOPPER_AABB = URN_AABB.offset(0.0, 0.375, 0.0);

    public BlockUrn() {
        super(Material.ROCK);
        this.setHardness(2.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPE, (Comparable)((Object)EnumType.EMPTY)).withProperty((IProperty)UNDERHOPPER, (Comparable)Boolean.valueOf(false)));
    }

    public static ItemStack getStack(EnumType type, int count) {
        return new ItemStack(BWMBlocks.URN, count, type.getMeta());
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        BlockPos down = pos.down();
        BlockFaceShape blockfaceshape = worldIn.getBlockState(down).getBlockFaceShape((IBlockAccess)worldIn, down, EnumFacing.UP);
        boolean below = blockfaceshape != BlockFaceShape.BOWL && blockfaceshape != BlockFaceShape.UNDEFINED;
        BlockPos up = pos.up();
        IBlockState state = worldIn.getBlockState(up);
        boolean above = state.getBlock() == BWMBlocks.SINGLE_MACHINES && worldIn.getBlockState(up).getValue(BlockMechMachines.TYPE) == BlockMechMachines.EnumType.HOPPER;
        return below || above;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canPlaceBlockAt(worldIn, pos)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos);
    }

    public int damageDropped(IBlockState state) {
        int meta = ((EnumType)((Object)state.getValue(TYPE))).getMeta();
        return meta > 7 ? meta : 0;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"underhopper=false,urntype=empty", "underhopper=false,urntype=12", "underhopper=false,urntype=25", "underhopper=false,urntype=37", "underhopper=false,urntype=50", "underhopper=false,urntype=62", "underhopper=false,urntype=75", "underhopper=false,urntype=87", "underhopper=false,urntype=full", "underhopper=false,urntype=void"};
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)(state = state.getActualState(world, pos)).getValue((IProperty)UNDERHOPPER)).booleanValue()) {
            return UNDER_HOPPER_AABB;
        }
        return URN_AABB;
    }

    @Override
    public boolean isSoulSensitive(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public int getMaximumSoulIntake(IBlockAccess world, BlockPos pos) {
        int meta = ((EnumType)((Object)world.getBlockState(pos).getValue(TYPE))).getMeta();
        if (meta < 8) {
            return 8 - meta;
        }
        if (meta == 9) {
            return 64;
        }
        return 0;
    }

    @Override
    public int processSouls(World world, BlockPos pos, int souls) {
        return Math.min(this.getMaximumSoulIntake((IBlockAccess)world, pos), souls);
    }

    @Override
    public boolean consumeSouls(World world, BlockPos pos, int souls) {
        int meta = ((EnumType)((Object)world.getBlockState(pos).getValue(TYPE))).getMeta();
        if (souls > 1 && meta != 9) {
            int newMeta = meta + souls;
            if (newMeta == 8) {
                InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWMBlocks.URN, 1, 8));
                return world.setBlockToAir(pos);
            }
            return world.setBlockState(pos, this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta))));
        }
        return meta == 9;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        int[] souls;
        int chance;
        int meta = ((EnumType)((Object)world.getBlockState(pos).getValue(TYPE))).getMeta();
        if (meta > 0 && rand.nextInt(chance = 80 - (souls = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 64})[meta - 1] / 2) == 0) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            world.playSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_GHAST_AMBIENT, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.1f + 0.45f, false);
            float flX = (float)x + rand.nextFloat();
            float flY = (float)y + rand.nextFloat() * 0.5f + 0.625f;
            float flZ = (float)z + rand.nextFloat();
            world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos up = pos.up();
        Block block = world.getBlockState(up).getBlock();
        if (block != null && block == BWMBlocks.SINGLE_MACHINES && world.getBlockState(up).getValue(BlockMechMachines.TYPE) == BlockMechMachines.EnumType.HOPPER) {
            return state.withProperty((IProperty)UNDERHOPPER, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            if (!type.used) continue;
            items.add((Object)BlockUrn.getStack(type, 1));
        }
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, UNDERHOPPER});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    public static enum EnumType implements IStringSerializable
    {
        EMPTY("empty", 0, true),
        ONE("12", 1, false),
        TWO("25", 2, false),
        THREE("37", 3, false),
        FOUR("50", 4, false),
        FIVE("62", 5, false),
        SIX("75", 6, false),
        SEVEN("87", 7, false),
        FULL("full", 8, true),
        VOID("void", 9, true);

        private static final EnumType[] VALUES;
        private String name;
        private int meta;
        private boolean used;

        private EnumType(String name, int meta, boolean used) {
            this.name = name;
            this.meta = meta;
            this.used = used;
        }

        public static EnumType byMeta(int meta) {
            return VALUES[meta % 10];
        }

        public String getName() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        static {
            VALUES = EnumType.values();
        }
    }
}

