/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.items.ItemMaterial;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUnfiredPottery
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.create((String)"potterytype", EnumType.class);
    private static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB URN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875);
    private static final AxisAlignedBB VASE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB BRICK_AABB = new AxisAlignedBB(0.25, 0.0, 0.0625, 0.75, 0.375, 0.9375);

    public BlockUnfiredPottery() {
        super(Material.CLAY);
        this.setSoundType(SoundType.GROUND);
        this.setHardness(0.5f);
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPE, (Comparable)((Object)EnumType.CRUCIBLE)));
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.UNFIRED_POTTERY, 1, type.getMeta());
    }

    @Override
    public String[] getVariants() {
        return new String[]{"potterytype=crucible", "potterytype=planter", "potterytype=urn", "potterytype=vase", "potterytype=brick", "potterytype=nether_brick"};
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return state.withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            items.add((Object)BlockUnfiredPottery.getStack(type));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = (EnumType)((Object)state.getValue(TYPE));
        switch (type) {
            case BRICK: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.CLAY_BALL)});
            }
            case NETHER_BRICK: {
                return Lists.newArrayList((Object[])new ItemStack[]{ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHER_SLUDGE)});
            }
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public int damageDropped(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = (EnumType)((Object)state.getValue(TYPE));
        switch (type) {
            case CRUCIBLE: 
            case PLANTER: {
                return BLOCK_AABB;
            }
            case URN: {
                return URN_AABB;
            }
            case VASE: {
                return VASE_AABB;
            }
            case BRICK: 
            case NETHER_BRICK: {
                return BRICK_AABB;
            }
        }
        return NULL_AABB;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return world.isSideSolid(pos.down(), EnumFacing.UP);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (!world.isSideSolid(pos.down(), EnumFacing.UP)) {
            this.dropBlockAsItem(world, pos, state, 0);
            world.setBlockToAir(pos);
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumType implements IStringSerializable
    {
        CRUCIBLE(0, "crucible"),
        PLANTER(1, "planter"),
        URN(2, "urn"),
        VASE(3, "vase"),
        BRICK(4, "brick"),
        NETHER_BRICK(5, "nether_brick");

        private static final EnumType[] VALUES;
        private String name;
        private int meta;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumType byMeta(int meta) {
            return VALUES[meta];
        }

        public int getMeta() {
            return this.meta;
        }

        public String getName() {
            return this.name;
        }

        static {
            VALUES = EnumType.values();
        }
    }
}

