/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BWMBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockStickBase
extends BWMBlock {
    public static final PropertyEnum<Connection> CONNECTION = PropertyEnum.create((String)"connection", Connection.class);
    public static final PropertyBool GROUND = PropertyBool.create((String)"ground");

    public BlockStickBase(Material material) {
        super(material);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTION, GROUND});
    }

    public int damageDropped(IBlockState state) {
        return 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean ground = (meta & 1) == 1;
        int connection = meta >> 1;
        return this.getDefaultState().withProperty((IProperty)GROUND, (Comparable)Boolean.valueOf(ground)).withProperty(CONNECTION, (Comparable)((Object)Connection.VALUES[connection]));
    }

    public int getMetaFromState(IBlockState state) {
        int connection = ((Connection)((Object)state.getValue(CONNECTION))).ordinal() << 1;
        int ground = (Boolean)state.getValue((IProperty)GROUND) != false ? 1 : 0;
        return ground | connection;
    }

    public abstract IBlockState getConnections(IBlockState var1, IBlockAccess var2, BlockPos var3);

    public abstract double getHeight(IBlockState var1);

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState newState = state;
        if (worldIn.getBlockState(pos.down()).isBlockNormalCube()) {
            newState = newState.withProperty((IProperty)GROUND, (Comparable)Boolean.valueOf(true));
        }
        IBlockState above = worldIn.getBlockState(pos.up());
        Block block = above.getBlock();
        return this.getConnections(newState, worldIn, pos);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing face) {
        return face.getAxis() == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_SMALL : BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        double y = this.getHeight(state);
        return new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, y, 0.5625);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    private void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canPlaceBlockAt(worldIn, pos)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    public static enum Connection implements IStringSerializable
    {
        DISCONNECTED,
        CONNECTED,
        CANDLE,
        SKULL;

        public static Connection[] VALUES;

        public String getName() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = Connection.values();
        }
    }
}

