/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.blocks.tile.TileEntitySteelAnvil;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class BlockSteelAnvil
extends BlockContainer {
    public BlockSteelAnvil() {
        super(Material.IRON);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setHardness(5.0f);
        this.setResistance(2000.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.setSoundType(SoundType.ANVIL);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.NORTH));
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (facing.ordinal() < 2) {
            facing = DirUtils.convertEntityOrientationToFlatFacing(placer, facing);
        }
        return state.withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)facing.rotateY());
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing)state.getValue((IProperty)DirUtils.HORIZONTAL)) {
            case NORTH: 
            case SOUTH: {
                return new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0);
            }
            case EAST: 
            case WEST: {
                return new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 0.75);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)DirUtils.HORIZONTAL)).getHorizontalIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.getHorizontal((int)meta));
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.HORIZONTAL});
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.isRemote) {
            return true;
        }
        playerIn.openGui((Object)BWMod.instance, 0, worldIn, pos.getX(), pos.getY(), pos.getZ());
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySteelAnvil();
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntitySteelAnvil();
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntitySteelAnvil anvil = (TileEntitySteelAnvil)worldIn.getTileEntity(pos);
        InvUtils.ejectInventoryContents(worldIn, pos, (IItemHandler)anvil.inventory);
        super.breakBlock(worldIn, pos, state);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.getAxis() == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }
}

