/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BlockCandle;
import betterwithmods.common.blocks.BlockStickBase;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockShaft
extends BlockStickBase {
    private static final Set<Material> grounds = Sets.newHashSet((Object[])new Material[]{Material.GRASS, Material.SAND, Material.GROUND, Material.SNOW});

    public BlockShaft() {
        super(Material.WOOD);
    }

    @Override
    public IBlockState getConnections(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState above = world.getBlockState(pos.up());
        Block block = above.getBlock();
        if (block instanceof BlockTorch || block instanceof BlockSkull || block instanceof BlockCandle) {
            return state.withProperty((IProperty)CONNECTION, (Comparable)((Object)BlockStickBase.Connection.CONNECTED));
        }
        return state;
    }

    @Override
    public double getHeight(IBlockState state) {
        BlockStickBase.Connection c = (BlockStickBase.Connection)((Object)state.getValue((IProperty)CONNECTION));
        return c == BlockStickBase.Connection.DISCONNECTED ? 0.75 : 1.0;
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        Material material = worldIn.getBlockState(pos.down()).getMaterial();
        return grounds.contains(material);
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.NULL_AABB;
    }
}

