/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockAnchor;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRope
extends BWMBlock {
    private static final AxisAlignedBB ROPE_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);

    public BlockRope() {
        super(Material.CIRCUITS);
        this.setSoundType(SoundType.PLANT);
        this.setHardness(0.5f);
    }

    public static boolean placeRopeUnder(ItemStack stack, World world, BlockPos pos, EntityPlayer player) {
        if (!stack.isEmpty() || player == null) {
            BlockPos bp = BlockRope.getLowestRopeBlock(world, pos).down();
            Block block = world.getBlockState(bp).getBlock();
            if ((world.isAirBlock(bp) || block.isReplaceable((IBlockAccess)world, bp)) && ((BlockRope)BWMBlocks.ROPE.getDefaultState().getBlock()).canBlockStay(world, bp)) {
                world.setBlockState(bp, BWMBlocks.ROPE.getDefaultState());
                world.playSound(null, bp, BWMBlocks.ROPE.getSoundType(BWMBlocks.ROPE.getDefaultState(), world, null, null).getPlaceSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (player != null && !player.capabilities.isCreativeMode) {
                    stack.shrink(1);
                }
                return true;
            }
        }
        return false;
    }

    public static BlockPos getLowestRopeBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            BlockPos down = pos.down();
            Block below = world.getBlockState(down).getBlock();
            if (below == BWMBlocks.ROPE) {
                return BlockRope.getLowestRopeBlock(world, down);
            }
            return pos;
        }
        return null;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.getHeldItem(hand);
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof ItemBlock && ((ItemBlock)heldItem.getItem()).getBlock() == this) {
            return BlockRope.placeRopeUnder(heldItem, worldIn, pos, playerIn);
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        Block blockAbove = world.getBlockState(pos.up()).getBlock();
        boolean supported = false;
        if (blockAbove == BWMBlocks.ANCHOR) {
            EnumFacing facing = ((BlockAnchor)BWMBlocks.ANCHOR).getFacing(world.getBlockState(pos.up()));
            boolean bl = supported = facing != EnumFacing.UP;
        }
        if (blockAbove == this) {
            supported = true;
        }
        if (blockAbove == BWMBlocks.SINGLE_MACHINES && world.getBlockState(pos.up()).getValue(BlockMechMachines.TYPE) == BlockMechMachines.EnumType.PULLEY) {
            supported = true;
        }
        return supported;
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return this.canBlockStay(world, pos);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ROPE_AABB;
    }

    public EnumFacing getFacing(IBlockState state) {
        return null;
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityPlayer;
    }

    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.getAxis() != EnumFacing.Axis.Y ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER_SMALL;
    }
}

