/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.registry.crafting.IngredientTool;
import betterwithmods.util.InvUtils;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlanter
extends BWMBlock
implements IMultiVariants,
IGrowable {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.create((String)"plantertype", EnumType.class);

    public BlockPlanter() {
        super(Material.ROCK);
        this.setTickRandomly(true);
        this.setHardness(1.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPE, (Comparable)((Object)EnumType.EMPTY)));
        this.setHarvestLevel("pickaxe", 0);
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.PLANTER, 1, type.getMeta());
    }

    @Override
    public String[] getVariants() {
        return new String[]{"plantertype=empty", "plantertype=farmland", "plantertype=grass", "plantertype=soul_sand", "plantertype=fertile", "plantertype=sand", "plantertype=water_still", "plantertype=gravel", "plantertype=red_sand", "plantertype=dirt"};
    }

    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        return state.getValue(TYPE) == EnumType.GRASS && tintIndex > -1 ? (world != null && pos != null ? BiomeColorHelper.getGrassColorAtPos((IBlockAccess)world, (BlockPos)pos) : ColorizerGrass.getGrassColor((double)0.5, (double)1.0)) : -1;
    }

    public int damageDropped(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    private EnumType getTypeFromStack(ItemStack stack) {
        for (EnumType type : EnumType.VALUES) {
            if (!type.apply(stack)) continue;
            return type;
        }
        return null;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = PlayerHelper.getHolding(player, hand);
        EnumType type = (EnumType)((Object)world.getBlockState(pos).getValue(TYPE));
        EnumType newType = this.getTypeFromStack(heldItem);
        switch (type) {
            case EMPTY: {
                if (newType == null || newType == EnumType.EMPTY || newType == EnumType.FARMLAND || newType == EnumType.FERTILE) break;
                if (world.isRemote) {
                    return true;
                }
                if (!player.isCreative() && !InvUtils.usePlayerItem(player, EnumFacing.UP, heldItem, 1)) break;
                world.playSound(null, pos, newType == EnumType.WATER ? SoundEvents.ITEM_BUCKET_EMPTY : newType.getState().getBlock().getSoundType(state, world, pos, (Entity)player).getPlaceSound(), SoundCategory.BLOCKS, 1.0f, world.rand.nextFloat() * 0.1f + 0.9f);
                player.swingArm(hand);
                return world.setBlockState(pos, state.withProperty(TYPE, (Comparable)((Object)newType)));
            }
            case WATER: {
                if (!heldItem.isItemEqual(new ItemStack(Items.BUCKET))) break;
                if (world.isRemote) {
                    return true;
                }
                if (InvUtils.usePlayerItem(player, EnumFacing.UP, heldItem, 1)) {
                    InvUtils.givePlayer(player, EnumFacing.UP, InvUtils.asNonnullList(new ItemStack(Items.WATER_BUCKET)));
                }
                player.swingArm(hand);
                world.playSound(null, pos, SoundEvents.ITEM_BUCKET_FILL, SoundCategory.BLOCKS, 1.0f, world.rand.nextFloat() * 0.1f + 0.9f);
                world.setBlockState(pos, state.withProperty(TYPE, (Comparable)((Object)EnumType.EMPTY)));
                break;
            }
            case GRASS: 
            case DIRT: {
                if (newType == EnumType.FERTILE) {
                    ItemDye.applyBonemeal((ItemStack)heldItem, (World)world, (BlockPos)pos, (EntityPlayer)player, (EnumHand)hand);
                }
                if (newType == EnumType.FARMLAND) {
                    heldItem.damageItem(1, (EntityLivingBase)player);
                    player.swingArm(hand);
                    world.playSound(player, pos, SoundEvents.ITEM_HOE_TILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.setBlockState(pos, state.withProperty(TYPE, (Comparable)((Object)newType)));
                    break;
                }
            }
            case SOULSAND: {
                break;
            }
            case FERTILE: {
                break;
            }
            case FARMLAND: {
                if (newType == EnumType.FERTILE) {
                    if (world.isRemote) {
                        return true;
                    }
                    if (!InvUtils.usePlayerItem(player, EnumFacing.UP, heldItem, 1)) break;
                    world.playSound(null, pos, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.BLOCKS, 0.25f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    world.setBlockState(pos, state.withProperty(TYPE, (Comparable)((Object)newType)));
                    world.playEvent(2005, pos.up(), 0);
                    break;
                }
            }
            case SAND: 
            case GRAVEL: 
            case REDSAND: {
                if (newType != EnumType.EMPTY) break;
                if (!player.isCreative()) {
                    InvUtils.givePlayer(player, EnumFacing.UP, InvUtils.asNonnullList(BWMRecipes.getStackFromState(type.getState())));
                }
                heldItem.damageItem(1, (EntityLivingBase)player);
                world.playSound(null, pos, type.getState().getBlock().getSoundType(state, world, pos, (Entity)player).getBreakSound(), SoundCategory.BLOCKS, 1.0f, world.rand.nextFloat() * 0.1f + 0.9f);
                world.setBlockState(pos, state.withProperty(TYPE, (Comparable)((Object)newType)));
            }
        }
        return false;
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.isRemote) {
            EnumType type = (EnumType)((Object)world.getBlockState(pos).getValue(TYPE));
            BlockPos up = pos.up();
            if (world.isAirBlock(up)) {
                switch (type) {
                    case DIRT: {
                        int zP;
                        int yP;
                        int xP;
                        BlockPos checkPos;
                        if (world.getLight(up) <= 8 || world.getBlockState(checkPos = pos.add(xP = rand.nextInt(3) - 1, yP = rand.nextInt(3) - 1, zP = rand.nextInt(3) - 1)).getBlock() != Blocks.GRASS) break;
                        world.setBlockState(pos, this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.GRASS)));
                        break;
                    }
                    case GRASS: {
                        if (rand.nextInt(100) == 0) {
                            world.getBiome(pos).plantFlower(world, rand, up);
                            if (world.getLight(up) > 8) {
                                for (int i = 0; i < 4; ++i) {
                                    int zP;
                                    int yP;
                                    int xP = rand.nextInt(3) - 1;
                                    BlockPos checkPos = pos.add(xP, yP = rand.nextInt(3) - 1, zP = rand.nextInt(3) - 1);
                                    if (world.getBlockState(checkPos) != Blocks.DIRT || world.getBlockState(checkPos) != Blocks.DIRT.getDefaultState()) continue;
                                    world.setBlockState(checkPos, Blocks.GRASS.getDefaultState());
                                }
                            }
                        }
                    }
                    case FERTILE: {
                        if (!(world.getBlockState(up).getBlock() instanceof IPlantable)) break;
                        IPlantable plant = (IPlantable)world.getBlockState(up).getBlock();
                        if (!this.canSustainPlant(world.getBlockState(pos), (IBlockAccess)world, pos, EnumFacing.UP, plant) || !world.getBlockState(up).getBlock().getTickRandomly()) break;
                        IBlockState cropState = world.getBlockState(up);
                        world.getBlockState(up).getBlock().updateTick(world, up, cropState, rand);
                        world.getBlockState(up).getBlock().updateTick(world, up, cropState, rand);
                        if (rand.nextInt(100) != 0) break;
                        world.setBlockState(pos, this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.DIRT)));
                    }
                }
            }
        }
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return world.getBlockState(pos).getValue(TYPE) == EnumType.FERTILE;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing dir, IPlantable plant) {
        BlockPos up = pos.up();
        EnumPlantType plantType = plant.getPlantType(world, up);
        return dir == EnumFacing.UP && ((EnumType)((Object)world.getBlockState(pos).getValue(TYPE))).isType(plantType);
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            items.add((Object)BlockPlanter.getStack(type));
        }
    }

    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        if (state.getValue(TYPE) == EnumType.GRASS && source.getY() == pos.getY() + 1) {
            world.setBlockState(pos, state.withProperty(TYPE, (Comparable)((Object)EnumType.DIRT)));
        }
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face != EnumFacing.UP) {
            return face == EnumFacing.DOWN ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
        }
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case EMPTY: 
            case WATER: {
                return BlockFaceShape.BOWL;
            }
        }
        return BlockFaceShape.SOLID;
    }

    public boolean canGrow(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return state.getValue(TYPE) == EnumType.GRASS;
    }

    public boolean canUseBonemeal(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.canGrow(worldIn, pos, state, worldIn.isRemote);
    }

    public void grow(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos blockpos = pos.up();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    if (!worldIn.isAirBlock(blockpos1)) continue block0;
                    if (rand.nextInt(8) == 0) {
                        worldIn.getBiome(blockpos1).plantFlower(worldIn, rand, blockpos1);
                        continue block0;
                    }
                    IBlockState iblockstate1 = Blocks.TALLGRASS.getDefaultState().withProperty((IProperty)BlockTallGrass.TYPE, (Comparable)BlockTallGrass.EnumType.GRASS);
                    if (!Blocks.TALLGRASS.canBlockStay(worldIn, blockpos1, iblockstate1)) continue block0;
                    worldIn.setBlockState(blockpos1, iblockstate1, 3);
                    continue block0;
                }
                if (worldIn.getBlockState((blockpos1 = blockpos1.add(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).down()).getBlock() != Blocks.GRASS || worldIn.getBlockState(blockpos1).isNormalCube()) continue block0;
                ++j;
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        EMPTY("empty", new IngredientTool("shovel"), Blocks.AIR.getDefaultState(), 0, new EnumPlantType[0]),
        FARMLAND("farmland", new IngredientTool(s -> s.getItem() instanceof ItemHoe, ItemStack.EMPTY), Blocks.DIRT.getDefaultState(), 1, new EnumPlantType[]{EnumPlantType.Crop, EnumPlantType.Plains}),
        GRASS("grass", StackIngredient.fromStacks(new ItemStack((Block)Blocks.GRASS)), Blocks.GRASS.getDefaultState(), 2, new EnumPlantType[]{EnumPlantType.Plains}),
        SOULSAND("soul_sand", StackIngredient.fromStacks(new ItemStack(Blocks.SOUL_SAND)), Blocks.SOUL_SAND.getDefaultState(), 3, new EnumPlantType[]{EnumPlantType.Nether}),
        FERTILE("fertile", StackIngredient.fromStacks(new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage())), Blocks.DIRT.getDefaultState(), 4, new EnumPlantType[]{EnumPlantType.Crop, EnumPlantType.Plains}),
        SAND("sand", StackIngredient.fromStacks(new ItemStack((Block)Blocks.SAND)), Blocks.SAND.getDefaultState(), 5, new EnumPlantType[]{EnumPlantType.Desert, EnumPlantType.Beach}),
        WATER("water_still", StackIngredient.fromStacks(new ItemStack(Items.WATER_BUCKET)), Blocks.WATER.getDefaultState(), 6, new EnumPlantType[]{EnumPlantType.Water}),
        GRAVEL("gravel", StackIngredient.fromStacks(new ItemStack(Blocks.GRAVEL)), Blocks.GRAVEL.getDefaultState(), 7, new EnumPlantType[]{EnumPlantType.Cave}),
        REDSAND("red_sand", StackIngredient.fromStacks(new ItemStack((Block)Blocks.SAND, 1, BlockSand.EnumType.RED_SAND.getMetadata())), Blocks.SAND.getDefaultState().withProperty((IProperty)BlockSand.VARIANT, (Comparable)BlockSand.EnumType.RED_SAND), 8, new EnumPlantType[]{EnumPlantType.Desert, EnumPlantType.Beach}),
        DIRT("dirt", StackIngredient.fromStacks(new ItemStack(Blocks.DIRT)), Blocks.DIRT.getDefaultState(), 9, new EnumPlantType[]{EnumPlantType.Plains});

        private static final EnumType[] VALUES;
        private String name;
        private IBlockState state;
        private int meta;
        private EnumPlantType[] type;
        private Ingredient ingredient;

        private EnumType(String name, Ingredient ingredient, IBlockState state, int meta, EnumPlantType[] type) {
            this.name = name;
            this.ingredient = ingredient;
            this.state = state;
            this.meta = meta;
            this.type = type;
        }

        public static EnumType byMeta(int meta) {
            return VALUES[meta];
        }

        public String getName() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean isType(EnumPlantType type) {
            return this.type.length != 0 && Arrays.asList(this.type).contains(type);
        }

        public IBlockState getState() {
            return this.state;
        }

        public boolean apply(ItemStack stack) {
            return this.ingredient.apply(stack);
        }

        public ItemStack getStack() {
            return Lists.newArrayList((Object[])this.ingredient.getMatchingStacks()).stream().findFirst().orElse(ItemStack.EMPTY);
        }

        static {
            VALUES = EnumType.values();
        }
    }
}

