/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.blocks.BlockPane;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;

public class BlockMultiPane
extends BlockPane
implements IMultiVariants {
    public static final PropertyEnum<EnumPaneType> TYPES = PropertyEnum.create((String)"type", EnumPaneType.class);

    public BlockMultiPane() {
        super(Material.WOOD);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setHardness(2.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPES, (Comparable)((Object)EnumPaneType.OAK)).withProperty((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(false)));
        this.setSoundType(SoundType.WOOD);
    }

    @Override
    public String[] getVariants() {
        String[] var = new String[BlockPlanks.EnumType.values().length];
        for (int i = 0; i < var.length; ++i) {
            var[i] = "east=false,north=true,south=true,type=" + BlockPlanks.EnumType.byMetadata((int)i) + ",west=false";
        }
        return var;
    }

    public int damageDropped(IBlockState state) {
        return ((EnumPaneType)((Object)state.getValue(TYPES))).getMeta();
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumPaneType)((Object)state.getValue(TYPES))).getMeta();
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumPaneType type : EnumPaneType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPES, (Comparable)((Object)EnumPaneType.byMeta(meta)));
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPES, DirUtils.SOUTH, DirUtils.EAST, DirUtils.NORTH, DirUtils.WEST});
    }

    public static enum EnumPaneType implements IStringSerializable
    {
        OAK(0, "oak"),
        SPRUCE(1, "spruce"),
        BIRCH(2, "birch"),
        JUNGLE(3, "jungle"),
        ACACIA(4, "acacia"),
        DARK_OAK(5, "dark_oak");

        private static final EnumPaneType[] META_LOOKUP;
        private String name;
        private int meta;

        private EnumPaneType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumPaneType byMeta(int meta) {
            return META_LOOKUP[meta];
        }

        public String getName() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        static {
            META_LOOKUP = new EnumPaneType[EnumPaneType.values().length];
            EnumPaneType[] enumPaneTypeArray = EnumPaneType.values();
            int n = enumPaneTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPaneType type;
                EnumPaneType.META_LOOKUP[type.getMeta()] = type = enumPaneTypeArray[i];
            }
        }
    }
}

