/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.util.DirUtils;
import jline.internal.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMiningCharge
extends BlockTNT {
    private static final AxisAlignedBB D_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB U_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB N_AABB = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB S_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
    private static final AxisAlignedBB W_AABB = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB E_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);

    public BlockMiningCharge() {
        this.setSoundType(SoundType.PLANT);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
        switch (facing) {
            case DOWN: {
                return D_AABB;
            }
            case UP: {
                return U_AABB;
            }
            case NORTH: {
                return N_AABB;
            }
            case SOUTH: {
                return S_AABB;
            }
            case WEST: {
                return W_AABB;
            }
            case EAST: {
                return E_AABB;
            }
        }
        return FULL_BLOCK_AABB;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXPLODE, DirUtils.FACING});
    }

    public void explode(World worldIn, BlockPos pos, IBlockState state, @Nullable EntityLivingBase igniter) {
        if (!worldIn.isRemote && ((Boolean)state.getValue((IProperty)EXPLODE)).booleanValue()) {
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, igniter, this.getFacing(state));
            worldIn.spawnEntity((Entity)miningCharge);
            worldIn.playSound(null, miningCharge.posX, miningCharge.posY, miningCharge.posZ, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.offset(side.getOpposite()), side);
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        super.onBlockAdded(worldIn, pos, state);
        if (worldIn.isBlockPowered(pos)) {
            this.onBlockDestroyedByPlayer(worldIn, pos, state.withProperty((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)));
            worldIn.setBlockToAir(pos);
        }
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos other) {
        if (worldIn.isBlockPowered(pos)) {
            this.onBlockDestroyedByPlayer(worldIn, pos, state.withProperty((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)));
            worldIn.setBlockToAir(pos);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.onBlockDestroyedByExplosion(world, pos, explosion);
        world.setBlockToAir(pos);
    }

    public void onBlockDestroyedByExplosion(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.isRemote) {
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, explosionIn.getExplosivePlacedBy(), this.getFacing(worldIn.getBlockState(pos)));
            miningCharge.setFuse((short)(worldIn.rand.nextInt(miningCharge.getFuse() / 4) + miningCharge.getFuse() / 8));
            worldIn.spawnEntity((Entity)miningCharge);
        }
    }

    public void onBlockDestroyedByPlayer(World worldIn, BlockPos pos, IBlockState state) {
        this.explode(worldIn, pos, state, null);
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EntityArrow entityarrow;
        if (!worldIn.isRemote && entityIn instanceof EntityArrow && (entityarrow = (EntityArrow)entityIn).isBurning()) {
            EntityLivingBase shooter = entityarrow.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.shootingEntity : null;
            this.explode(worldIn, pos, worldIn.getBlockState(pos).withProperty((IProperty)EXPLODE, (Comparable)Boolean.valueOf(true)), shooter);
            worldIn.setBlockToAir(pos);
        }
    }

    public boolean canDropFromExplosion(Explosion explosionIn) {
        return false;
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean explode = (meta & 1) > 0;
        EnumFacing facing = EnumFacing.getFront((int)(meta >> 1));
        return this.getDefaultState().withProperty((IProperty)EXPLODE, (Comparable)Boolean.valueOf(explode)).withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public int getMetaFromState(IBlockState state) {
        int facing = ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex() << 1;
        int explode = (Boolean)state.getValue((IProperty)EXPLODE) != false ? 1 : 0;
        return explode | facing;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != this.getFacing(state).getOpposite() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }
}

