/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockBUD;
import betterwithmods.util.item.ToolsManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLight
extends BWMBlock
implements IMultiVariants {
    public static final PropertyBool ACTIVE = PropertyBool.create((String)"active");

    public BlockLight() {
        super(Material.GLASS);
        this.setHardness(2.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.setSoundType(SoundType.GLASS);
        ToolsManager.setPickaxesAsEffectiveAgainst(this);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"active=true"};
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (!world.isRemote) {
            if (((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue() && !world.isBlockPowered(pos) && !this.isIndirectlyPowered(world, pos)) {
                world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else if (!((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue() && (world.isBlockPowered(pos) || this.isIndirectlyPowered(world, pos))) {
                world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (!world.isRemote) {
            if (((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue() && !world.isBlockPowered(pos) && !this.isIndirectlyPowered(world, pos)) {
                world.scheduleUpdate(pos, (Block)this, 4);
            } else if (!((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue() && (world.isBlockPowered(pos) || this.isIndirectlyPowered(world, pos))) {
                world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
                for (EnumFacing facing : EnumFacing.VALUES) {
                    if (world.getBlockState(pos.offset(facing)).getBlock() != this) continue;
                    world.neighborChanged(pos.offset(facing), (Block)this, pos);
                }
            }
        }
    }

    private boolean isIndirectlyPowered(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            BlockPos check = pos.offset(facing);
            if (world.isAirBlock(check) || world.getBlockState(check).getBlock() instanceof BlockBUD || !world.isBlockPowered(check)) continue;
            return true;
        }
        return false;
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.isRemote && ((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue() && !world.isBlockPowered(pos)) {
            world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
            for (EnumFacing facing : EnumFacing.VALUES) {
                if (world.getBlockState(pos.offset(facing)).getBlock() != this) continue;
                world.neighborChanged(pos.offset(facing), (Block)this, pos);
            }
        }
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)ACTIVE) != false ? 1 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta == 1));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState neighbor = world.getBlockState(pos.offset(side));
        return state != neighbor;
    }
}

