/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockDetector;
import betterwithmods.common.blocks.BlockInvisibleLight;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLens
extends BlockRotate
implements IMultiVariants {
    public static final PropertyBool LIT = PropertyBool.create((String)"lit");
    public static final int RANGE = 256;

    public BlockLens() {
        super(Material.IRON);
        this.setHardness(3.5f);
        this.setTickRandomly(true);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("pickaxe", 0);
    }

    public int tickRate(World world) {
        return 5;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        world.scheduleBlockUpdate(pos, (Block)this, 3, 5);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        EnumFacing face = DirUtils.convertEntityOrientationToFacing(entity, side);
        return this.setFacingInBlock(state, face);
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.cleanupLightToFacing(world, pos, (EnumFacing)state.getValue((IProperty)DirUtils.FACING));
        super.breakBlock(world, pos, state);
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        this.setFacingInBlock(state, facing);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.scheduleBlockUpdate(pos, (Block)this, 3, 5);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        this.cleanupLight(world, pos);
        EnumFacing dir = this.getFacing((IBlockAccess)world, pos);
        boolean isLightDetector = this.isFacingBlockDetector(world, pos);
        if (!isLightDetector) {
            boolean sunlight = this.isLightFromSun(world, pos);
            boolean lightOn = this.isInputLit(world, pos);
            if (this.isLit((IBlockAccess)world, pos) != lightOn) {
                this.setLit(world, pos, lightOn);
            }
            EnumFacing expectedFacing = DirUtils.getOpposite(this.getFacing((IBlockAccess)world, pos));
            BlockPos offset = pos.offset(dir);
            if (this.isLit((IBlockAccess)world, pos) && (world.isAirBlock(offset) || world.getBlockState(offset).getBlock() == BWMBlocks.LIGHT_SOURCE)) {
                int currentRange = 256;
                for (int i = 1; i < 256; ++i) {
                    BlockPos bPos = pos.offset(dir, i);
                    if (world.isAirBlock(bPos)) continue;
                    currentRange = i + 1;
                    break;
                }
                AxisAlignedBB bb = FULL_BLOCK_AABB.offset(pos);
                int mod = dir.getAxisDirection().getOffset();
                switch (dir.getAxis()) {
                    case X: {
                        bb = bb.expand((double)(mod * currentRange), 0.0, 0.0);
                        break;
                    }
                    case Y: {
                        bb = bb.expand(0.0, (double)(mod * currentRange), 0.0);
                        break;
                    }
                    case Z: {
                        bb = bb.expand(0.0, 0.0, (double)(mod * currentRange));
                    }
                }
                List box = world.getEntitiesWithinAABB(Entity.class, bb);
                HashMap map = Maps.newHashMap();
                for (Entity e : box) {
                    int distance = 0;
                    switch (dir.getAxis()) {
                        case X: {
                            distance = (int)((double)pos.getX() - e.posX);
                            break;
                        }
                        case Y: {
                            distance = (int)((double)pos.getY() - e.posY);
                            break;
                        }
                        case Z: {
                            distance = (int)((double)pos.getZ() - e.posZ);
                        }
                    }
                    map.put(Math.abs(distance), e);
                }
                for (int i = 1; i < currentRange; ++i) {
                    BlockPos bPos = pos.offset(dir, i);
                    IBlockState lightState = BWMBlocks.LIGHT_SOURCE.getDefaultState();
                    if (world.isAirBlock(bPos)) {
                        if (map.containsKey(i)) {
                            world.setBlockState(bPos, lightState.withProperty((IProperty)DirUtils.FACING, (Comparable)expectedFacing).withProperty((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(sunlight)));
                        } else {
                            if (world.getBlockState(bPos).getBlock() == BWMBlocks.LIGHT_SOURCE && ((EnumFacing)world.getBlockState(bPos).getValue((IProperty)DirUtils.FACING)).ordinal() < expectedFacing.ordinal()) {
                                if (((Boolean)world.getBlockState(bPos).getValue((IProperty)BlockInvisibleLight.SUNLIGHT)).booleanValue()) {
                                    lightState = lightState.withProperty((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(true));
                                }
                                world.setBlockState(bPos, lightState.withProperty((IProperty)DirUtils.FACING, (Comparable)expectedFacing));
                                continue;
                            }
                            if (world.isAirBlock(bPos)) continue;
                            if (world.getBlockState(bPos = bPos.offset(dir.getOpposite())).getBlock() != BWMBlocks.LIGHT_SOURCE || world.getBlockState(bPos).getBlock() == BWMBlocks.LIGHT_SOURCE && ((EnumFacing)world.getBlockState(bPos).getValue((IProperty)DirUtils.FACING)).ordinal() < expectedFacing.ordinal()) {
                                world.setBlockState(bPos, lightState.withProperty((IProperty)DirUtils.FACING, (Comparable)expectedFacing).withProperty((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(sunlight)));
                            }
                        }
                    } else {
                        if (world.isAirBlock(bPos)) continue;
                        BlockPos dPos = bPos.offset(dir.getOpposite());
                        if (world.getBlockState(dPos).getBlock() != BWMBlocks.LIGHT_SOURCE || world.getBlockState(dPos).getBlock() == BWMBlocks.LIGHT_SOURCE && ((EnumFacing)world.getBlockState(dPos).getValue((IProperty)DirUtils.FACING)).ordinal() <= expectedFacing.ordinal()) {
                            if (world.getBlockState(dPos).getBlock() == BWMBlocks.LIGHT_SOURCE && ((Boolean)world.getBlockState(dPos).getValue((IProperty)BlockInvisibleLight.SUNLIGHT)).booleanValue()) {
                                lightState = lightState.withProperty((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(sunlight));
                            }
                            world.setBlockState(dPos, lightState.withProperty((IProperty)DirUtils.FACING, (Comparable)expectedFacing));
                        }
                    }
                    break;
                }
            } else if (!this.isLit((IBlockAccess)world, pos)) {
                for (int i = 1; i < 256; ++i) {
                    BlockPos bPos = pos.offset(dir, i);
                    if (world.getBlockState(bPos).getBlock() == BWMBlocks.LIGHT_SOURCE) {
                        world.setBlockToAir(bPos);
                        continue;
                    }
                    if (world.isAirBlock(bPos)) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            boolean shouldBeOn;
            int lightValue = world.getLight(pos.offset(dir.getOpposite()));
            boolean bl = shouldBeOn = lightValue > 7;
            if (this.isLit((IBlockAccess)world, pos) != shouldBeOn) {
                this.setLit(world, pos, shouldBeOn);
            }
        }
        world.scheduleBlockUpdate(pos, (Block)this, 5, 5);
    }

    public EnumPushReaction getMobilityFlag(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacing(world.getBlockState(pos));
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public boolean isLit(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.getBlockState(pos).getValue((IProperty)LIT);
    }

    public void setLit(World world, BlockPos pos, boolean isOn) {
        boolean oldLit = (Boolean)world.getBlockState(pos).getValue((IProperty)LIT);
        if (isOn != oldLit) {
            world.setBlockState(pos, world.getBlockState(pos).withProperty((IProperty)LIT, (Comparable)Boolean.valueOf(isOn)));
            world.neighborChanged(pos, (Block)this, pos);
        }
    }

    private boolean isInputLit(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        EnumFacing dir = DirUtils.getOpposite(facing);
        BlockPos oppOff = pos.offset(dir);
        Block block = world.getBlockState(oppOff).getBlock();
        if (world.isAirBlock(oppOff) && world.canBlockSeeSky(oppOff)) {
            return world.getLightFor(EnumSkyBlock.SKY, oppOff) > 12 && world.isDaytime() && (!world.isRaining() || !world.isThundering());
        }
        return block.getLightValue(world.getBlockState(oppOff), (IBlockAccess)world, oppOff) > 12;
    }

    private boolean isFacingBlockDetector(World world, BlockPos pos) {
        EnumFacing detFacing;
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        BlockPos offset = pos.offset(facing);
        Block block = world.getBlockState(offset).getBlock();
        return block == BWMBlocks.DETECTOR && (detFacing = ((BlockDetector)block).getFacing(world.getBlockState(offset))) == DirUtils.getOpposite(facing);
    }

    private boolean isLightFromSun(World world, BlockPos pos) {
        EnumFacing facing = DirUtils.getOpposite(this.getFacing((IBlockAccess)world, pos));
        BlockPos offset = pos.offset(facing);
        if (world.isAirBlock(offset) && world.canBlockSeeSky(offset)) {
            return true;
        }
        return world.getBlockState(offset).getBlock() == BWMBlocks.LIGHT_SOURCE && (Boolean)world.getBlockState(offset).getValue((IProperty)BlockInvisibleLight.SUNLIGHT) != false;
    }

    private void cleanupLightToFacing(World world, BlockPos pos, EnumFacing facing) {
        EnumFacing opp = DirUtils.getOpposite(facing);
        for (int i = 1; i < 256; ++i) {
            BlockPos offset = pos.offset(facing, i);
            if (world.getBlockState(offset).getBlock() == BWMBlocks.LIGHT_SOURCE) {
                EnumFacing lightFace = ((BlockInvisibleLight)world.getBlockState(offset).getBlock()).getFacing((IBlockAccess)world, offset);
                if (lightFace != opp) continue;
                world.setBlockToAir(offset);
                break;
            }
            if (!world.isAirBlock(offset)) break;
        }
    }

    private void cleanupLight(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        EnumFacing oppFacing = DirUtils.getOpposite(facing);
        for (int i = 1; i < 256; ++i) {
            BlockLens lens;
            BlockPos offset = pos.offset(facing, i);
            if (world.getBlockState(offset).getBlock() == BWMBlocks.LIGHT_SOURCE) {
                EnumFacing lightFace = ((BlockInvisibleLight)world.getBlockState(offset).getBlock()).getFacing((IBlockAccess)world, offset);
                if (lightFace != oppFacing) continue;
                world.setBlockToAir(offset);
                continue;
            }
            if (!world.isAirBlock(offset) && world.getBlockState(offset).getBlock() == this && (lens = (BlockLens)world.getBlockState(pos).getBlock()).getFacing((IBlockAccess)world, offset) == facing) break;
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean lit = false;
        if (meta > 7) {
            lit = true;
            meta -= 8;
        }
        return this.getDefaultState().withProperty((IProperty)LIT, (Comparable)Boolean.valueOf(lit)).withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)meta));
    }

    public int getMetaFromState(IBlockState state) {
        int meta = (Boolean)state.getValue((IProperty)LIT) != false ? 8 : 0;
        return meta + ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, LIT});
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.setBlockState(pos, state.withProperty((IProperty)LIT, (Comparable)Boolean.valueOf(false)).cycleProperty((IProperty)DirUtils.FACING));
    }

    @Override
    public String[] getVariants() {
        return new String[]{"facing=north,lit=false"};
    }
}

