/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockLens;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInvisibleLight
extends BWMBlock {
    public static final PropertyBool SUNLIGHT = PropertyBool.create((String)"sunlight");

    public BlockInvisibleLight() {
        super(Material.AIR);
        this.setLightLevel(1.0f);
        this.setTickRandomly(true);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)SUNLIGHT, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP));
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int tickRate(World world) {
        return 6;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public EnumPushReaction getMobilityFlag(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        world.scheduleUpdate(pos, (Block)this, 5);
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean canCollideCheck(IBlockState state, boolean playerActivated) {
        return false;
    }

    public boolean isReplaceable(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public void dropBlockAsItemWithChance(World world, BlockPos pos, IBlockState state, float f, int fortune) {
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (world.getBlockState(pos).getBlock() == BWMBlocks.LIGHT_SOURCE) {
            world.setBlockToAir(pos);
        }
    }

    public void onEntityCollidedWithBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityLiving living;
        if (!world.isRemote && ((Boolean)world.getBlockState(pos).getValue((IProperty)SUNLIGHT)).booleanValue() && entity instanceof EntityLiving && (living = (EntityLiving)entity).getCreatureAttribute() == EnumCreatureAttribute.UNDEAD) {
            living.setFire(4);
        }
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.hasClearViewToLens(world, pos)) {
            world.setBlockToAir(pos);
        } else {
            world.scheduleUpdate(pos, (Block)this, 5);
        }
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return (EnumFacing)world.getBlockState(pos).getValue((IProperty)DirUtils.FACING);
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    private boolean hasClearViewToLens(World world, BlockPos pos) {
        boolean clear = true;
        EnumFacing face = this.getFacing(world.getBlockState(pos));
        for (int i = 1; i < 32; ++i) {
            int z;
            int y;
            BlockPos bPos = pos.offset(face, i);
            int x = bPos.getX();
            List entity = world.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB((double)x, (double)(y = bPos.getY()), (double)(z = bPos.getZ()), (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            if (entity.size() > 0) {
                clear = false;
            } else if (world.getBlockState(bPos).getBlock() == BWMBlocks.LIGHT_SOURCE) {
                clear = false;
            } else {
                if (world.getBlockState(bPos).getBlock() == BWMBlocks.LENS) {
                    BlockLens lens = (BlockLens)world.getBlockState(bPos).getBlock();
                    return lens.getFacing((IBlockAccess)world, bPos) == DirUtils.getOpposite(this.getFacing((IBlockAccess)world, bPos));
                }
                if (!world.isAirBlock(bPos)) {
                    clear = false;
                }
            }
            if (!clear) break;
        }
        return clear;
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean sun = false;
        if (meta > 7) {
            sun = true;
            meta -= 8;
        }
        return this.getDefaultState().withProperty((IProperty)SUNLIGHT, (Comparable)Boolean.valueOf(sun)).withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)meta));
    }

    public int getMetaFromState(IBlockState state) {
        int meta = (Boolean)state.getValue((IProperty)SUNLIGHT) != false ? 8 : 0;
        return meta + ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, SUNLIGHT});
    }
}

