/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.registry.KilnStructureManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFireStoked
extends BlockFire {
    public BlockFireStoked() {
        this.disableStats();
        this.setLightLevel(1.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)AGE, (Comparable)Integer.valueOf(0)).withProperty((IProperty)NORTH, (Comparable)Boolean.FALSE).withProperty((IProperty)EAST, (Comparable)Boolean.FALSE).withProperty((IProperty)SOUTH, (Comparable)Boolean.FALSE).withProperty((IProperty)WEST, (Comparable)Boolean.FALSE).withProperty((IProperty)UPPER, (Comparable)Boolean.FALSE));
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.setFire(40);
    }

    public int tickRate(World world) {
        return 52;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        BlockPos below;
        Block belowBlock;
        if (!this.canPlaceBlockAt(world, pos)) {
            world.setBlockToAir(pos);
        }
        if ((belowBlock = world.getBlockState(below = pos.down()).getBlock()) == BWMBlocks.HIBACHI) {
            if (!belowBlock.isFireSource(world, below, EnumFacing.UP)) {
                world.setBlockToAir(pos);
            }
        } else {
            world.setBlockState(pos, Blocks.FIRE.getDefaultState());
            return;
        }
        BlockPos above = pos.up();
        KilnStructureManager.createKiln(world, above);
        if (world.getBlockState(pos).getBlock() == BWMBlocks.STOKED_FLAME) {
            int meta = (Integer)world.getBlockState(pos).getValue((IProperty)AGE);
            if (meta < 15) {
                world.setBlockState(pos, world.getBlockState(pos).withProperty((IProperty)AGE, (Comparable)Integer.valueOf(++meta)));
            }
            boolean flag1 = world.isBlockinHighHumidity(pos);
            this.setFire(world, pos.east(), 300, rand, meta, EnumFacing.WEST);
            this.setFire(world, pos.west(), 300, rand, meta, EnumFacing.EAST);
            this.setFire(world, pos.down(), 250, rand, meta, EnumFacing.UP);
            this.setFire(world, pos.up(), 250, rand, meta, EnumFacing.DOWN);
            this.setFire(world, pos.north(), 300, rand, meta, EnumFacing.SOUTH);
            this.setFire(world, pos.south(), 300, rand, meta, EnumFacing.NORTH);
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int j1 = 1; j1 <= 1; ++j1) {
                    for (int k1 = 1; k1 <= 4; ++k1) {
                        BlockPos blockpos;
                        int i2;
                        int l1 = 100;
                        if (k1 > 1) {
                            l1 += (k1 - 1) * 100;
                        }
                        if ((i2 = this.getNeighborEncouragement(world, blockpos = pos.add(i1, k1, j1))) <= 0) continue;
                        int j2 = (i2 + 40 + world.getDifficulty().getDifficultyId() * 7) / (meta + 30);
                        if (flag1) {
                            j2 /= 2;
                        }
                        if (j2 <= 0 || rand.nextInt(l1) > j2 || world.isRaining() && this.canDie(world, blockpos)) continue;
                        int k2 = meta + rand.nextInt(5) / 4;
                        if (k2 > 15) {
                            k2 = 15;
                        }
                        world.setBlockState(blockpos, Blocks.FIRE.getDefaultState().withProperty((IProperty)AGE, (Comparable)Integer.valueOf(k2)));
                    }
                }
            }
            if (meta >= 3) {
                world.setBlockState(pos, Blocks.FIRE.getDefaultState().withProperty((IProperty)AGE, (Comparable)Integer.valueOf(15)), 3);
                return;
            }
            world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world) + world.rand.nextInt(10), 5);
        }
    }

    public int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.isAirBlock(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(worldIn.getBlockState(pos.offset(enumfacing)).getBlock().getFireSpreadSpeed((IBlockAccess)worldIn, pos.offset(enumfacing), enumfacing.getOpposite()), i);
        }
        return i;
    }

    private void setFire(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int i = worldIn.getBlockState(pos).getBlock().getFlammability((IBlockAccess)worldIn, pos, face);
        if (random.nextInt(chance) < i) {
            IBlockState iblockstate = worldIn.getBlockState(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.isRainingAt(pos)) {
                int j = age + random.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                worldIn.setBlockState(pos, Blocks.FIRE.getDefaultState().withProperty((IProperty)AGE, (Comparable)Integer.valueOf(j)), 3);
            } else {
                worldIn.setBlockToAir(pos);
            }
            if (iblockstate.getBlock() == Blocks.TNT) {
                Blocks.TNT.onBlockDestroyedByPlayer(worldIn, pos, iblockstate.withProperty((IProperty)BlockTNT.EXPLODE, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }
}

