/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockHemp;
import betterwithmods.common.blocks.BlockLens;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDetector
extends BlockRotate {
    public static final PropertyBool ACTIVE = PropertyBool.create((String)"active");

    public BlockDetector() {
        super(Material.ROCK);
        this.setHardness(3.5f);
        this.setSoundType(SoundType.STONE);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.setTickRandomly(true);
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int tickRate(World world) {
        return 4;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return this.setFacingInBlock(state, DirUtils.convertEntityOrientationToFacing(entity, side));
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, @Nullable EnumFacing face, float hitX, float hitY, float hitZ) {
        super.onBlockPlacedBy(world, pos, state, placer, stack, face, hitX, hitY, hitZ);
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, entity, stack);
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        this.setFacingInBlock(state, facing);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        this.setBlockOn(world, pos, false);
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        this.setBlockOn(world, pos, this.detectBlock(world, pos));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean canProvidePower(IBlockState state) {
        return (Boolean)state.getValue((IProperty)ACTIVE);
    }

    public int getWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isBlockOn(world, pos) ? 15 : 0;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public boolean isBlockOn(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.getBlockState(pos).getValue((IProperty)ACTIVE);
    }

    public void setBlockOn(World world, BlockPos pos, boolean on) {
        if (on != this.isBlockOn((IBlockAccess)world, pos)) {
            IBlockState state = world.getBlockState(pos).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(on));
            if (on) {
                world.playSound(null, pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.7f);
            }
            world.setBlockState(pos, state);
            for (int i = 0; i < 6; ++i) {
                world.neighborChanged(pos.offset(EnumFacing.getFront((int)i)), (Block)this, pos);
            }
        }
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public boolean detectBlock(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing(world.getBlockState(pos));
        BlockPos offset = pos.offset(facing);
        IBlockState blockState = world.getBlockState(offset);
        Block target = blockState.getBlock();
        if (facing == EnumFacing.UP && world.isAirBlock(offset) && world.getBiomeForCoordsBody(offset).canRain() && world.canBlockSeeSky(offset) && (world.isRaining() || world.isThundering())) {
            return true;
        }
        if (target == BWMBlocks.LENS) {
            BlockLens lens = (BlockLens)target;
            return lens.getFacing(blockState) == DirUtils.getOpposite(this.getFacing(world.getBlockState(pos))) && lens.isLit((IBlockAccess)world, offset);
        }
        if (blockState.getMaterial().isSolid() || target instanceof BlockVine || target instanceof BlockReed) {
            return true;
        }
        if (target == BWMBlocks.LIGHT_SOURCE) {
            return blockState.getValue((IProperty)DirUtils.FACING) == facing;
        }
        if (target instanceof BlockHemp) {
            return (Boolean)blockState.getValue((IProperty)BlockHemp.TOP);
        }
        if (world.isAirBlock(offset)) {
            int x = offset.getX();
            int y = offset.getY();
            int z = offset.getZ();
            AxisAlignedBB collisionBox = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            List entityList = world.getEntitiesWithinAABB(Entity.class, collisionBox);
            world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
            if (!entityList.isEmpty()) {
                return true;
            }
            BlockPos downOffset = offset.down();
            IBlockState downState = world.getBlockState(downOffset);
            Block downBlock = downState.getBlock();
            if (!(downBlock instanceof BlockHemp) && downBlock instanceof BlockCrops) {
                return ((BlockCrops)downBlock).isMaxAge(downState);
            }
            if (downBlock == Blocks.NETHER_WART) {
                return (Integer)downState.getValue((IProperty)BlockNetherWart.AGE) >= 3;
            }
        }
        return false;
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isActive)).withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)meta));
    }

    public int getMetaFromState(IBlockState state) {
        int meta = (Boolean)state.getValue((IProperty)ACTIVE) != false ? 8 : 0;
        return meta + ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, ACTIVE});
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).cycleProperty((IProperty)DirUtils.FACING));
    }
}

