/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.tile.IRopeConnector;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockRope;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import betterwithmods.common.blocks.tile.TileEntityBucket;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBucket
extends BWMBlock
implements IRopeConnector {
    public static final PropertyBool CONNECTED = PropertyBool.create((String)"connected");
    public static final PropertyBool IN_WATER = PropertyBool.create((String)"in_water");
    public static final PropertyBool HAS_WATER = PropertyBool.create((String)"has_water");

    public BlockBucket() {
        super(Material.IRON);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)CONNECTED, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)IN_WATER, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)HAS_WATER, (Comparable)Boolean.valueOf(false)));
        this.setHardness(5.0f);
        this.setResistance(10.0f);
        this.setSoundType(SoundType.METAL);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{IN_WATER, HAS_WATER, CONNECTED});
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return EnumFacing.UP;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBucket();
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState();
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState above = worldIn.getBlockState(pos.up());
        if (above.getBlock() instanceof BlockRope || worldIn.getTileEntity(pos.up()) instanceof TileEntityPulley) {
            return this.getDefaultState().withProperty((IProperty)CONNECTED, (Comparable)Boolean.valueOf(true));
        }
        return super.getActualState(state, worldIn, pos).withProperty((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean canMovePlatforms(World world, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

