/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockPlanter;
import betterwithmods.common.world.gen.feature.WorldGenBloodTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockBloodSapling
extends BlockBush {
    public static final PropertyInteger STAGE = PropertyInteger.create((String)"stage", (int)0, (int)1);
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockBloodSapling() {
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setSoundType(SoundType.PLANT);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.getBlockState(pos.down());
        return soil.getBlock().canSustainPlant(soil, (IBlockAccess)worldIn, pos.down(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        if (state.getBlock() == this) {
            IBlockState soil = world.getBlockState(pos.down());
            return soil.getBlock().canSustainPlant(soil, (IBlockAccess)world, pos.down(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustainBush(world.getBlockState(pos.down()));
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.getBlock() == Blocks.SOUL_SAND || state.getBlock() == BWMBlocks.PLANTER && state.getValue(BlockPlanter.TYPE) == BlockPlanter.EnumType.SOULSAND;
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.getValue((IProperty)STAGE) == 0) {
            world.setBlockState(pos, state.cycleProperty((IProperty)STAGE), 4);
        } else {
            this.generateTree(world, pos, state, rand);
        }
    }

    public boolean generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return false;
        }
        WorldGenBloodTree gen = new WorldGenBloodTree();
        world.setBlockState(pos, Blocks.AIR.getDefaultState());
        if (!gen.generate(world, rand, pos)) {
            world.setBlockState(pos, state);
            return false;
        }
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Nether;
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)STAGE) == 1 ? 8 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)STAGE, (Comparable)Integer.valueOf(meta == 8 ? 1 : 0));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }
}

