/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBloodLeaves
extends BlockLeaves {
    public BlockBloodLeaves() {
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DECAYABLE, (Comparable)Boolean.valueOf(false)));
        this.setCreativeTab(BWCreativeTabs.BWTAB);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    public BlockPlanks.EnumType getWoodType(int meta) {
        return BlockPlanks.EnumType.JUNGLE;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack((Block)this, 1, 0));
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)BWMBlocks.BLOOD_SAPLING);
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BWMBlocks.BLOOD_SAPLING);
    }

    protected ItemStack getSilkTouchDrop(IBlockState state) {
        return new ItemStack(BWMBlocks.BLOOD_LEAVES);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return Blocks.LEAVES.isOpaqueCube(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return Blocks.LEAVES.getBlockLayer();
    }

    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        this.leavesFancy = !Blocks.LEAVES.isOpaqueCube(state);
        return super.shouldSideBeRendered(state, world, pos, side);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)DECAYABLE, (Comparable)Boolean.valueOf((meta & 4) == 0)).withProperty((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int getMetaFromState(IBlockState state) {
        int meta;
        int n = meta = (Boolean)state.getValue((IProperty)DECAYABLE) != false ? 4 : 0;
        if (((Boolean)state.getValue((IProperty)CHECK_DECAY)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DECAYABLE, CHECK_DECAY});
    }
}

