/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBUD
extends BWMBlock {
    private static final PropertyBool REDSTONE = PropertyBool.create((String)"redstone");
    private static Set<Block> BLACKLIST = Sets.newHashSet((Object[])new Block[]{BWMBlocks.BUDDY_BLOCK, Blocks.REDSTONE_WIRE, Blocks.POWERED_REPEATER, Blocks.UNPOWERED_REPEATER, Blocks.REDSTONE_TORCH, Blocks.UNLIT_REDSTONE_TORCH, BWMBlocks.LIGHT});

    public BlockBUD() {
        super(Material.ROCK);
        this.setHardness(3.5f);
        this.setSoundType(SoundType.STONE);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP));
        this.setHarvestLevel("pickaxe", 0);
    }

    public static void addBlacklistBlock(Block block) {
        BLACKLIST.add(block);
    }

    public int tickRate(World var1) {
        return 5;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, REDSTONE});
    }

    public IBlockState getStateFromMeta(int meta) {
        int facing = meta >> 1;
        boolean redstone = (meta & 1) == 1;
        return this.getDefaultState().withProperty((IProperty)REDSTONE, (Comparable)Boolean.valueOf(redstone)).withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)facing));
    }

    public int getMetaFromState(IBlockState state) {
        int facing = ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex();
        int redstone = (Boolean)state.getValue((IProperty)REDSTONE) != false ? 1 : 0;
        return redstone | facing << 1;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand).withProperty((IProperty)DirUtils.FACING, (Comparable)DirUtils.convertEntityOrientationToFacing(placer, EnumFacing.UP));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        super.onBlockAdded(worldIn, pos, state);
        worldIn.scheduleUpdate(pos, state.getBlock(), 1);
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos other) {
        if (!this.isRedstoneOn((IBlockAccess)world, pos) && !BLACKLIST.contains(blockIn)) {
            world.scheduleUpdate(pos, state.getBlock(), this.tickRate(world));
        }
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.isRedstoneOn((IBlockAccess)worldIn, pos)) {
            this.setRedstone(worldIn, pos, false);
        } else {
            this.setRedstone(worldIn, pos, true);
            worldIn.scheduleUpdate(pos, state.getBlock(), this.tickRate(worldIn));
        }
    }

    public void setRedstone(World world, BlockPos pos, boolean newState) {
        if (newState != this.isRedstoneOn((IBlockAccess)world, pos)) {
            BlockPos facing;
            if (newState) {
                world.playSound(null, pos, SoundEvents.BLOCK_DISPENSER_FAIL, SoundCategory.BLOCKS, 1.0f, 0.5f);
            }
            if (!world.isAirBlock(facing = pos.offset(this.getFacing(world.getBlockState(pos))))) {
                world.getBlockState(facing).getBlock().onNeighborChange((IBlockAccess)world, facing, pos);
            }
            world.setBlockState(pos, world.getBlockState(pos).withProperty((IProperty)REDSTONE, (Comparable)Boolean.valueOf(newState)));
        }
    }

    public boolean isRedstoneOn(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.getBlockState(pos).getValue((IProperty)REDSTONE);
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getPower(blockAccess, pos, side);
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getPower(blockAccess, pos, side);
    }

    public int getPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side.getOpposite() == this.getFacing(world.getBlockState(pos)) && this.isRedstoneOn(world, pos) ? 15 : 0;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }
}

