/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAesthetic
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.create((String)"blocktype", EnumType.class);

    public BlockAesthetic() {
        super(Material.ROCK);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPE, (Comparable)((Object)EnumType.CHOPBLOCK)));
    }

    public static IBlockState getVariant(EnumType type) {
        return BWMBlocks.AESTHETIC.getDefaultState().withProperty(TYPE, (Comparable)((Object)type));
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.AESTHETIC, 1, type.getMeta());
    }

    public static ItemStack getStack(EnumType type, int amount) {
        return new ItemStack(BWMBlocks.AESTHETIC, amount, type.getMeta());
    }

    public float getBlockHardness(IBlockState state, World worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.getValue(TYPE))).getHardness();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((EnumType)((Object)state.getValue(TYPE))).getSoundType();
    }

    public Material getMaterial(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMaterial();
    }

    public MapColor getMapColor(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMapColor();
    }

    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((EnumType)((Object)world.getBlockState(pos).getValue(TYPE))).getResistance();
    }

    public boolean canDropFromExplosion(Explosion explosionIn) {
        return false;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"blocktype=chopping", "blocktype=chopping_blood", "blocktype=nether_clay", "blocktype=hellfire", "blocktype=rope", "blocktype=flint", "blocktype=whitestone", "blocktype=whitecobble", "blocktype=enderblock", "blocktype=padding", "blocktype=soap", "blocktype=dung", "blocktype=wicker", "blocktype=nethercoal"};
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            if (type.name.equalsIgnoreCase("unused")) continue;
            items.add((Object)BlockAesthetic.getStack(type));
        }
    }

    public int damageDropped(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return world.getBlockState(pos).getValue(TYPE) == EnumType.HELLFIRE;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumType implements IStringSerializable
    {
        CHOPBLOCK(0, "chopping", MapColor.STONE),
        CHOPBLOCKBLOOD(1, "chopping_blood", MapColor.NETHERRACK),
        NETHERCLAY(2, "nether_clay", MapColor.NETHERRACK),
        HELLFIRE(3, "hellfire", MapColor.ADOBE),
        ROPE(4, "rope", MapColor.DIRT, Material.CLOTH, SoundType.CLOTH, 1.0f, 5.0f),
        FLINT(5, "flint", MapColor.STONE),
        WHITESTONE(6, "whitestone", MapColor.CLOTH),
        WHITECOBBLE(7, "whitecobble", MapColor.CLOTH),
        ENDERBLOCK(8, "enderblock", MapColor.CYAN),
        PADDING(9, "padding", MapColor.CLOTH, Material.CLOTH, SoundType.CLOTH, 1.0f, 5.0f),
        SOAP(10, "soap", MapColor.PINK, Material.GROUND, SoundType.GROUND, 1.0f, 5.0f),
        DUNG(11, "dung", MapColor.BROWN, Material.GROUND, SoundType.GROUND, 1.0f, 2.0f),
        WICKER(12, "wicker", MapColor.BROWN, Material.WOOD, SoundType.WOOD, 1.0f, 5.0f),
        NETHERCOAL(13, "nethercoal", MapColor.RED, Material.REDSTONE_LIGHT, SoundType.STONE, 5.0f, 10.0f);

        private static final EnumType[] VALUES;
        private final int meta;
        private final String name;
        private final MapColor color;
        private final Material material;
        private final SoundType soundType;
        private final float hardness;
        private final float resistance;

        private EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.color = color;
            this.material = Material.ROCK;
            this.soundType = SoundType.STONE;
            this.hardness = 1.5f;
            this.resistance = 10.0f;
        }

        private EnumType(int meta, String name, MapColor color, Material material, SoundType soundType, float hardness, float resistance) {
            this.meta = meta;
            this.name = name;
            this.color = color;
            this.material = material;
            this.soundType = soundType;
            this.hardness = hardness;
            this.resistance = resistance;
        }

        public static EnumType byMeta(int meta) {
            return VALUES[meta];
        }

        public String getName() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.color;
        }

        public Material getMaterial() {
            return this.material;
        }

        public SoundType getSoundType() {
            return this.soundType;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        static {
            VALUES = EnumType.values();
        }
    }
}

