/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.client.BWParticleDigging;
import betterwithmods.client.baking.IStateParticleBakedModel;
import betterwithmods.common.blocks.mini.BlockMini;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.util.item.ToolsManager;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BWMBlock
extends Block {
    public BWMBlock(Material material) {
        super(material);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        if (material == Material.WOOD || material == BlockMini.MINI) {
            ToolsManager.setAxesAsEffectiveAgainst(this);
            this.setSoundType(SoundType.WOOD);
            this.setHarvestLevel("axe", 0);
        } else if (material == Material.ROCK) {
            this.setSoundType(SoundType.STONE);
            this.setHarvestLevel("pickaxe", 1);
            ToolsManager.setPickaxesAsEffectiveAgainst(this);
        }
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isRemote && worldIn.getTileEntity(pos) instanceof TileBasic) {
            ((TileBasic)worldIn.getTileEntity(pos)).onBreak();
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        this.onBlockPlacedBy(world, pos, state, placer, stack, null, 0.5f, 0.5f, 0.5f);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, @Nullable EnumFacing face, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (this.hasTileEntity(state) && (tile = world.getTileEntity(pos)) instanceof TileBasic) {
            ((TileBasic)tile).onPlacedBy(placer, face, stack, hitX, hitY, hitZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TextureAtlasSprite sprite;
        IBlockState state = world.getBlockState(pos);
        IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().getModelForState(state);
        if (model instanceof IStateParticleBakedModel && (sprite = ((IStateParticleBakedModel)model).getParticleTexture(state = this.getExtendedState(state.getActualState((IBlockAccess)world, pos), (IBlockAccess)world, pos), null)) != null) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.addEffect((Particle)new BWParticleDigging(world, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, state, pos, sprite, this.getParticleTintIndex()));
                    }
                }
            }
            return true;
        }
        return super.addDestroyEffects(world, pos, manager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().getModelForState(state);
        if (model instanceof IStateParticleBakedModel) {
            BlockPos pos = target.getBlockPos();
            EnumFacing side = target.sideHit;
            TextureAtlasSprite sprite = ((IStateParticleBakedModel)model).getParticleTexture(state = this.getExtendedState(state.getActualState((IBlockAccess)world, pos), (IBlockAccess)world, pos), side);
            if (sprite != null) {
                int i = pos.getX();
                int j = pos.getY();
                int k = pos.getZ();
                AxisAlignedBB axisalignedbb = state.getBoundingBox((IBlockAccess)world, pos);
                double d0 = (double)i + RANDOM.nextDouble() * (axisalignedbb.maxX - axisalignedbb.minX - (double)0.2f) + (double)0.1f + axisalignedbb.minX;
                double d1 = (double)j + RANDOM.nextDouble() * (axisalignedbb.maxY - axisalignedbb.minY - (double)0.2f) + (double)0.1f + axisalignedbb.minY;
                double d2 = (double)k + RANDOM.nextDouble() * (axisalignedbb.maxZ - axisalignedbb.minZ - (double)0.2f) + (double)0.1f + axisalignedbb.minZ;
                if (side == EnumFacing.DOWN) {
                    d1 = (double)j + axisalignedbb.minY - (double)0.1f;
                }
                if (side == EnumFacing.UP) {
                    d1 = (double)j + axisalignedbb.maxY + (double)0.1f;
                }
                if (side == EnumFacing.NORTH) {
                    d2 = (double)k + axisalignedbb.minZ - (double)0.1f;
                }
                if (side == EnumFacing.SOUTH) {
                    d2 = (double)k + axisalignedbb.maxZ + (double)0.1f;
                }
                if (side == EnumFacing.WEST) {
                    d0 = (double)i + axisalignedbb.minX - (double)0.1f;
                }
                if (side == EnumFacing.EAST) {
                    d0 = (double)i + axisalignedbb.maxX + (double)0.1f;
                }
                Particle particle = new BWParticleDigging(world, d0, d1, d2, 0.0, 0.0, 0.0, state, pos, sprite, this.getParticleTintIndex()).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f);
                manager.addEffect(particle);
                return true;
            }
        }
        return false;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState stateAgain, EntityLivingBase entity, int numberOfParticles) {
        return super.addLandingEffects(state, world, pos, stateAgain, entity, numberOfParticles);
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return super.addRunningEffects(state, world, pos, entity);
    }

    public int getParticleTintIndex() {
        return -1;
    }
}

