/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.render;

import betterwithmods.module.hardcore.creatures.EntityTentacle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTentacle
extends Render<EntityTentacle> {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/particle/particles.png");

    public RenderTentacle(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(EntityTentacle entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntityLivingBase angler = entity.getAngler();
        if (angler != null && !this.renderOutlines) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)((double)((float)x) + 0.5), (double)((double)((float)y) + 0.5), (double)((double)((float)z) + 0.5));
            GlStateManager.enableRescaleNormal();
            GlStateManager.scale((float)0.5f, (float)0.5f, (float)0.5f);
            this.bindEntityTexture(entity);
            Tessellator tessellator = Tessellator.getInstance();
            BufferBuilder bufferbuilder = tessellator.getBuffer();
            GlStateManager.rotate((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotate((float)((float)(this.renderManager.options.thirdPersonView == 2 ? -1 : 1) * -this.renderManager.playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.renderOutlines) {
                GlStateManager.enableColorMaterial();
                GlStateManager.enableOutlineMode((int)this.getTeamColor(entity));
            }
            bufferbuilder.begin(7, DefaultVertexFormats.POSITION_TEX_NORMAL);
            bufferbuilder.pos(-0.5, -0.5, 0.0).tex(0.0625, 0.1875).normal(0.0f, 1.0f, 0.0f).endVertex();
            bufferbuilder.pos(0.5, -0.5, 0.0).tex(0.125, 0.1875).normal(0.0f, 1.0f, 0.0f).endVertex();
            bufferbuilder.pos(0.5, 0.5, 0.0).tex(0.125, 0.125).normal(0.0f, 1.0f, 0.0f).endVertex();
            bufferbuilder.pos(-0.5, 0.5, 0.0).tex(0.0625, 0.125).normal(0.0f, 1.0f, 0.0f).endVertex();
            tessellator.draw();
            if (this.renderOutlines) {
                GlStateManager.disableOutlineMode();
                GlStateManager.disableColorMaterial();
            }
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            float f7 = angler.getSwingProgress(partialTicks);
            float f8 = MathHelper.sin((float)(MathHelper.sqrt((float)f7) * (float)Math.PI));
            float f9 = (angler.prevRenderYawOffset + (angler.renderYawOffset - angler.prevRenderYawOffset) * partialTicks) * ((float)Math.PI / 180);
            double d0 = MathHelper.sin((float)f9);
            double d1 = MathHelper.cos((float)f9);
            double d4 = angler.prevPosX + (angler.posX - angler.prevPosX);
            double d5 = angler.prevPosY + (double)angler.getEyeHeight() + (angler.posY - angler.prevPosY) * (double)partialTicks - 0.15;
            double d6 = angler.prevPosZ + (angler.posZ - angler.prevPosZ);
            double d7 = angler.isSneaking() ? -0.1875 : 0.0;
            double d13 = entity.prevPosX + (entity.posX - entity.prevPosX) * (double)partialTicks;
            double d8 = entity.prevPosY + (entity.posY - entity.prevPosY) * (double)partialTicks + 0.25;
            double d9 = entity.prevPosZ + (entity.posZ - entity.prevPosZ) * (double)partialTicks;
            double d10 = (float)(d4 - d13);
            double d11 = (double)((float)(d5 - d8)) + d7;
            double d12 = (float)(d6 - d9);
            GlStateManager.disableTexture2D();
            GlStateManager.disableLighting();
            bufferbuilder.begin(3, DefaultVertexFormats.POSITION_COLOR);
            for (int i1 = 0; i1 <= 16; ++i1) {
                float f11 = (float)i1 / 16.0f;
                bufferbuilder.pos(x + d10 * (double)f11, y + d11 * (double)(f11 * f11 + f11) * 0.5 + 0.25, z + d12 * (double)f11).color(0, 0, 0, 255).endVertex();
            }
            tessellator.draw();
            GlStateManager.enableLighting();
            GlStateManager.enableTexture2D();
            super.doRender((Entity)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    protected ResourceLocation getEntityTexture(EntityTentacle entity) {
        return FISH_PARTICLES;
    }
}

