/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.render;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.util.DirUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderMiningCharge
extends Render<EntityMiningCharge> {
    public RenderMiningCharge(RenderManager renderManagerIn) {
        super(renderManagerIn);
        this.shadowSize = 0.5f;
    }

    public void doRender(EntityMiningCharge entity, double x, double y, double z, float entityYaw, float partialTicks) {
        IBlockState state = BWMBlocks.MINING_CHARGE.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)entity.getFacing());
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)x), (float)((float)y + 0.5f), (float)((float)z));
        if ((float)entity.getFuse() - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)entity.getFuse() - partialTicks + 1.0f) / 10.0f;
            f = MathHelper.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            GlStateManager.scale((float)f1, (float)f1, (float)f1);
        }
        float f2 = (1.0f - ((float)entity.getFuse() - partialTicks + 1.0f) / 100.0f) * 0.8f;
        this.bindEntityTexture(entity);
        GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)-0.5f, (float)-0.5f, (float)0.5f);
        blockrendererdispatcher.renderBlockBrightness(state, entity.getBrightness());
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)-1.0f, (float)0.0f, (float)0.0f);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode((int)this.getTeamColor(entity));
            blockrendererdispatcher.renderBlockBrightness(state, 1.0f);
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        } else if (entity.getFuse() / 5 % 2 == 0) {
            GlStateManager.disableTexture2D();
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.DST_ALPHA);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)f2);
            GlStateManager.doPolygonOffset((float)-3.0f, (float)-3.0f);
            GlStateManager.enablePolygonOffset();
            blockrendererdispatcher.renderBlockBrightness(state, 1.0f);
            GlStateManager.doPolygonOffset((float)0.0f, (float)0.0f);
            GlStateManager.disablePolygonOffset();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.disableBlend();
            GlStateManager.enableLighting();
            GlStateManager.enableTexture2D();
        }
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
        super.doRender((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityMiningCharge entity) {
        return TextureMap.LOCATION_BLOCKS_TEXTURE;
    }
}

