/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.model.render;

import betterwithmods.client.model.render.RenderUtils;
import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public abstract class PixelOperationSprite
extends TextureAtlasSprite {
    private final ResourceLocation location;

    protected PixelOperationSprite(String entry, ResourceLocation location) {
        super(entry);
        this.location = location;
    }

    public abstract int apply(int var1, int var2, int var3);

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation loc, Function<ResourceLocation, TextureAtlasSprite> getter) {
        BufferedImage image = RenderUtils.getTextureImage(this.location);
        if (image == null) {
            return false;
        }
        this.setIconWidth(image.getWidth());
        this.setIconHeight(image.getHeight());
        int[][] pixels = new int[Minecraft.getMinecraft().gameSettings.mipmapLevels + 1][];
        pixels[0] = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
        for (int i = 0; i < pixels[0].length; ++i) {
            pixels[0][i] = this.apply(i % image.getWidth(), i / image.getWidth(), pixels[0][i]);
        }
        this.clearFramesTextureData();
        this.framesTextureData.add(pixels);
        return false;
    }

    public static class Multiply
    extends PixelOperationSprite {
        private final int color;

        public Multiply(String entry, ResourceLocation location, int color) {
            super(entry, location);
            this.color = color;
        }

        @Override
        public int apply(int x, int y, int value) {
            return RenderUtils.multiplyColor(value, this.color);
        }
    }
}

