/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.gui;

import betterwithmods.client.container.other.ContainerInfernalEnchanter;
import betterwithmods.client.gui.GuiBase;
import betterwithmods.common.blocks.tile.TileEntityInfernalEnchanter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.ResourceLocation;

public class GuiInfernalEnchanter
extends GuiBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("betterwithmods", "textures/gui/infernal_enchanter.png");
    private static HashMap<Integer, String> numerals = Maps.newHashMap();
    private FontRenderer fontGalactic;
    private TileEntityInfernalEnchanter tile;
    private ContainerInfernalEnchanter container;
    private EntityPlayer player;

    public GuiInfernalEnchanter(EntityPlayer player, TileEntityInfernalEnchanter tile) {
        super(new ContainerInfernalEnchanter(player, tile), TEXTURE);
        this.container = (ContainerInfernalEnchanter)this.inventorySlots;
        this.player = player;
        this.tile = tile;
        this.ySize = 211;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
        if (this.fontGalactic == null) {
            this.fontGalactic = this.mc.standardGalacticFontRenderer;
        }
    }

    @Override
    protected void drawExtras(float partialTicks, int mouseX, int mouseY, int centerX, int centerY) {
        if (!this.inventorySlots.getSlot(0).getHasStack()) {
            this.drawTexturedModalRect(centerX + 17, centerY + 37, 176, 0, 16, 16);
        }
        if (!this.inventorySlots.getSlot(1).getHasStack()) {
            this.drawTexturedModalRect(centerX + 17, centerY + 75, 192, 0, 16, 16);
        }
        EnchantmentNameParts.getInstance().reseedRandomGenerator((long)this.container.xpSeed);
        for (int levelIndex = 0; levelIndex < this.container.enchantLevels.length; ++levelIndex) {
            this.mc.renderEngine.bindTexture(this.background);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int level = this.container.enchantLevels[levelIndex];
            if (level <= 0) continue;
            String levelString = String.valueOf(level);
            if (this.container.hasLevels(this.player, levelIndex) && this.container.hasBooks(levelIndex)) {
                int y = centerY + 17 + 19 * levelIndex;
                int x = centerX + 60;
                if (mouseX >= x && mouseX <= x + 108 && mouseY >= y && mouseY <= y + 19) {
                    this.drawTexturedModalRect(x, y, 108, 211, 108, 19);
                } else {
                    this.drawTexturedModalRect(x, y, 0, 211, 108, 19);
                }
            }
            String galacticText = EnchantmentNameParts.getInstance().generateNewRandomName(this.fontRenderer, 86 - this.fontRenderer.getStringWidth(levelString));
            this.fontGalactic.drawSplitString(galacticText, centerX + 62, centerY + 19 + 19 * levelIndex, 108, 3419941);
            this.fontRenderer.drawStringWithShadow(levelString, (float)(centerX + this.xSize - 10 - this.fontRenderer.getStringWidth(levelString)), (float)(centerY + 8 + 19 * (levelIndex + 1)), 8453920);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        for (Map.Entry<Integer, String> e : numerals.entrySet()) {
            this.fontRenderer.drawString(e.getValue(), 50 - this.fontRenderer.getStringWidth(e.getValue()) / 2, e.getKey().intValue(), 0x404040);
        }
    }

    @Override
    public String getTitle() {
        return this.tile.getName();
    }

    @Override
    public int getTitleY() {
        return 6;
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int xPos = (this.width - this.xSize) / 2;
        int yPos = (this.height - this.ySize) / 2;
        for (int levelIndex = 0; levelIndex < this.container.enchantLevels.length; ++levelIndex) {
            if (this.container.enchantLevels[levelIndex] == -1 || !this.container.hasLevels(this.player, levelIndex) || !this.container.hasBooks(levelIndex)) continue;
            int y = yPos + 17 + 19 * levelIndex;
            int x = xPos + 60;
            if (mouseX < x || mouseX > x + 108 || mouseY < y || mouseY > y + 19 || !this.container.enchantItem(this.player, levelIndex)) continue;
            this.mc.playerController.sendEnchantPacket(this.container.windowId, levelIndex);
        }
    }

    static {
        numerals.put(22, "I");
        numerals.put(41, "II");
        numerals.put(60, "III");
        numerals.put(79, "IV");
        numerals.put(98, "V");
    }
}

