/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.baking;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SimpleBakedModel
implements IBakedModel {
    private final List<BakedQuad>[] quads = new List[7];
    private final IBakedModel parent;
    private TextureAtlasSprite particle;

    public SimpleBakedModel() {
        this(null);
    }

    public SimpleBakedModel(IBakedModel parent) {
        this.parent = parent;
        for (int i = 0; i < this.quads.length; ++i) {
            this.quads[i] = new ArrayList<BakedQuad>();
        }
    }

    public void setParticle(TextureAtlasSprite particle) {
        this.particle = particle;
    }

    public void addQuad(EnumFacing side, BakedQuad quad) {
        this.quads[side == null ? 6 : side.ordinal()].add(quad);
    }

    public void addModel(IBakedModel model) {
        for (int i = 0; i < 7; ++i) {
            this.quads[i].addAll(model.getQuads(null, i == 6 ? null : EnumFacing.getFront((int)i), 0L));
        }
    }

    public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
        return this.quads[side == null ? 6 : side.ordinal()];
    }

    public boolean isAmbientOcclusion() {
        return this.parent != null ? this.parent.isAmbientOcclusion() : true;
    }

    public boolean isGui3d() {
        return this.parent != null ? this.parent.isGui3d() : true;
    }

    public boolean isBuiltInRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleTexture() {
        if (this.particle != null) {
            return this.particle;
        }
        return this.parent != null ? this.parent.getParticleTexture() : null;
    }

    public ItemOverrideList getOverrides() {
        return ItemOverrideList.NONE;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair pair = this.parent.handlePerspective(cameraTransformType);
        if (pair.getLeft() != this.parent) {
            return pair;
        }
        return ImmutablePair.of((Object)this, (Object)pair.getRight());
    }
}

