/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client;

import betterwithmods.common.blocks.BlockPlanter;
import betterwithmods.common.blocks.ItemBlockPlanter;
import betterwithmods.common.items.tools.BWMArmor;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;

public class ColorHandlers {
    public static final IBlockColor BlockPlanterColor = (state, worldIn, pos, tintIndex) -> state.getBlock() instanceof BlockPlanter ? ((BlockPlanter)state.getBlock()).colorMultiplier(state, worldIn, pos, tintIndex) : -1;
    public static final IBlockColor BlockFoliageColor = (state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.getFoliageColorAtPos((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.getFoliageColor((double)0.5, (double)1.0);
    public static final IBlockColor BlockBloodLeafColor = (state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? ColorHandlers.blendColors(11994630, BiomeColorHelper.getFoliageColorAtPos((IBlockAccess)worldIn, (BlockPos)pos)) : ColorHandlers.blendColors(11994630, ColorizerFoliage.getFoliageColor((double)0.5, (double)1.0));
    public static final IItemColor ItemPlanterColor = (stack, tintIndex) -> stack.getItem() instanceof ItemBlock && stack.getItem() instanceof ItemBlockPlanter ? ((ItemBlockPlanter)stack.getItem()).getColorFromItemStack(stack, tintIndex) : -1;
    public static final IItemColor ItemFoliageColor = (stack, tintIndex) -> BlockFoliageColor.colorMultiplier(((ItemBlock)stack.getItem()).getBlock().getDefaultState(), null, null, tintIndex);
    public static final IItemColor ItemBloodLeafColor = (stack, tintIndex) -> BlockBloodLeafColor.colorMultiplier(((ItemBlock)stack.getItem()).getBlock().getDefaultState(), null, null, tintIndex);
    public static final IItemColor armor = (stack, tintIndex) -> tintIndex != 1 && stack.getItem() instanceof BWMArmor ? ((BWMArmor)stack.getItem()).getColor(stack) : -1;

    public static int blendColors(int main, int blend) {
        float mRatio = 0.825f;
        float ratio = 0.175f;
        int mainA = main >> 24 & 0xFF;
        int mainR = (main & 0xFF0000) >> 16;
        int mainG = (main & 0xFF00) >> 8;
        int mainB = main & 0xFF;
        int blendA = blend >> 24 & 0xFF;
        int blendR = (blend & 0xFF0000) >> 16;
        int blendG = (blend & 0xFF00) >> 8;
        int blendB = blend & 0xFF;
        int a = (int)((float)mainA * mRatio + (float)blendA * ratio);
        int r = (int)((float)mainR * mRatio + (float)blendR * ratio);
        int g = (int)((float)mainG * mRatio + (float)blendG * ratio);
        int b = (int)((float)mainB * mRatio + (float)blendB * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

